---
title: Accessibility Tools for Web Developers
---
## Accessibility Tools for Web Developers
There are many tools and online resources that can help you to ensure that your web application meets all of the accessibility requirements.

### General 
- **[Chrome Accessibility Developer Tools](https://chrome.google.com/webstore/detail/accessibility-developer-t/fpkknkljclfencbdbgkenhalefipecmb?hl=en)**
   This is a Google Chrome extension that will add a new Accessibility sidebar pane in the Elements tab to the Chrome Developer tools. This new pane will display any properties that are relevant to the accessibility aspect of the element that you are currently inspecting. This extension also adds an accessibility audit that can be used to check whether the current web page violates any accessibility rules. 

- **[WAVE](https://wave.webaim.org/extension/)**
   This is another Chrome (and Firefox) extension that allows you to find accessibility defects on your web page.

- **[aXe](https://chrome.google.com/webstore/detail/axe/lhdoppojpmngadmnindnejefpokejbdd?hl=en-US)**
   This Google Chrome extension can find accessibility defects on your web page.

- **[tota11y](https://khan.github.io/tota11y/)**
   An accessibility visualization toolkit that checks how your website performs with assistive technologies.

- **[AccessLint](https://www.accesslint.com)**
   A GitHub app that checks your pull requests for accessibility issues.

### Color Contrast
- **[Check My Colours](https://www.checkmycolours.com)**
   This website checks if your website meets the accessibility requirements for color and contrast.

- **[Color Oracle](https://colororacle.org)**
   This application simulates color blindness. It is available on Windows, Mac and Linux.

- **[Accessible Color Palette Builder](https://toolness.github.io/accessible-color-matrix/)**
   This website allows you to edit a color palette and will create a table showing all of the possible color combinations, telling you which ones are accessible and which combinations to avoid using.
      
- **[WebAIM Color Contrast Checker](https://webaim.org/resources/contrastchecker/)**
   Website tool that allows you to test foreground and background color values and see if they pass AA and AAA color contrast ratios for small text and large text.

- **[Randoma11y Color Generator](https://randoma11y.com/)**
  This is an ongoing app project that randomly generates AA accessible web color palettes and allows end users to up vote or down vote color combinations. This site is good for Web Designers/Web Developers when starting a project that does not have predetermined colors.

### Screen Reader
A screen reader is a software application with assistive technology that attempts to convey what people with normal eyesight see on a display to their users via non-visual means, like text-to-speech. 
Developers can utilize a screen reader to understand how a webpage can be made accessible to such people and develop the page accordingly. Some of the most well known and widely used screen readers are:

- **[NVDA](https://www.nvaccess.org/)**
   NVDA(Non Visual Desktop Access) Screen reader is a Free & Open-source downloadable Screen Reader software for Windows OS.
   
- **[JAWS](https://www.freedomscientific.com/Products/Blindness/)**
   JAWS(Job Access With Speech) is a computer screen reader program which is available as licensed software for Windows.
   
- **[a11yproject](https://a11yproject.com/)**
   This site provides pracical guides and examples for implementing accessible features and components during web development. The site contains how-tos, myths, tips, and recommended accessibility tools. The project is community driven and can be contributed to on Github.
   
- **[ChromeVox](https://www.chromevox.com/)**
   ChromeVox is a Chrome Browser extension which can be used to render Webpages as text-to-speech.

#### More Resources
You can find many more tools for accessible web design on [this list made by the University of Minnesota Duluth](https://www.d.umn.edu/itss/training/online/webdesign/tools.html).

For information on creating and verfying accessibility for PDF documents, see the [Adobe XI Pro Guide](https://helpx.adobe.com/acrobat/using/create-verify-pdf-accessibility.html)

[This accessibility inspector by mozilla](https://developer.mozilla.org/en-US/docs/Tools/Accessibility_inspector) is built in to firefox can help check the accessibility of a webpage.
