---
title: Accessibility
---
## Accessibility
<strong>Web accessibility means that people with disabilities can use the Web</strong>.

More specifically, Web accessibility means that people with a wide range of disabilities can perceive, understand, navigate, and interact with the Web and that they can contribute to the Web. Web accessibility can make it easier for people to find a website, access it, and use it successfully, thus resulting in an increased audience (more users) and increased effectiveness (more useful).

Web accessibility encompasses all disabilities that affect access to the Web, including visual, auditory, physical, speech, cognitive, and neurological disabilities. The article [How People with Disabilities Use the Web](http://www.w3.org/WAI/intro/people-use-web/Overview.html) describes how different disabilities affect Web use and includes scenarios of people with disabilities using the Web.

Web accessibility also **benefits** people *without* disabilities. For example, a key principle of Web accessibility is designing Web sites and software that are flexible to meet different user needs, preferences, and situations. This **flexibility** also benefits people *without* disabilities in certain situations, such as people using a slow Internet connection, people with "temporary disabilities" such as a broken arm, and older people with changing abilities due to aging. The article [Developing a Web Accessibility Business Case for Your Organization](https://www.w3.org/WAI/bcase/Overview) describes many different benefits of Web accessibility, including **benefits for organizations**.

Web accessibility should also include the people who don't have access to the internet or to computers and also the countries with slow Internet.
A prominent guideline for web development was introduced by the [World Wide Web Consortium (W3C)](https://www.w3.org/), the [Web Accessibility Initiative](https://www.w3.org/WAI/) from which we get the [WAI-ARIA](https://developer.mozilla.org/en-US/docs/Learn/Accessibility/WAI-ARIA_basics), the Accessible Rich Internet Applications Suite. Where WAI tackles the semantics of HTML to more easily navigate the [DOM Tree](https://www.w3.org/TR/WD-DOM/introduction.html), ARIA attempts to make web apps, especially those developed with JavaScript and AJAX, more accessible. 

The use of images and graphics on websites can decrease accessibility for those with visual impairments. However, this doesn't mean designers should avoid using these visual elements. When used correctly, visual elements can convey the appropriate look and feel to users without disabilities. In order to use these elements appropriately, web designers must use alt text to communicate the message of these elements to those who cannot see them. Alt text should be short and to the point--generally [no more than five to 15 words](https://www.thoughtco.com/writing-great-alt-text-3466185). If a graphic is used to convey information that exceeds the limitations of alt text, that information should also exist as web text in order to be read by screen readers. [Learn more about alt text](https://webaim.org/techniques/alttext/).

Just like alt text has the ability to help people that are visually impaired, providing written documents or transcripts of the audio can help people that have hearing disabilities. Videos should always be captioned. Providing a written document or a transcript of what is being spoken makes this content accessible to people who are Deaf or hard of hearing, with speech-processing disabilities, those using devices without sound capability, and people on slow or data-limited devices that make loading videos cumbersome or impossible.

A high-level test of a website's accessibility can be conducted through several online tools.  One is a popular Chrome Browser extension known as <a href="http://wave.webaim.org/">WAVE</a>.  This will provide you with areas to focus on to present a usable experience for all visitors to the site.

The W3's WCAG (Web Content Accessibility Guidelines) also recommend a certain level of color contrast for text, stating that the foreground and background should be clearly separate. Because larger text is already easier to read than smaller text, the color contrast requirements are lower. [Learn more about the W3's colour contrast guidelines](https://www.w3.org/TR/UNDERSTANDING-WCAG20/visual-audio-contrast-contrast.html).

Copyright &copy; 2005 <a href="http://www.w3.org" shape="rect">World Wide Web Consortium</a>, (<a href="http://www.csail.mit.edu/" shape="rect">MIT</a>, <a href="http://www.ercim.org" shape="rect">ERCIM</a>, <a href="http://www.keio.ac.jp" shape="rect">Keio</a>, <a href="http://ev.buaa.edu.cn" shape="rect">Beihang</a>). http://www.w3.org/Consortium/Legal/2015/doc-license

### More Information:
<a href='https://www.w3.org/WAI/intro/accessibility.php' target='_blank' rel='nofollow'>w3.org introduction to accessibility.</a>

<a href='http://a11yproject.com/' target='_blank' rel='nofollow'>The A11Y Project</a>

<a href='https://webaim.org/intro/' target='_blank' rel='nofollow'>WebAIM: Introduction to Web Accessibility</a>
