---
title: Actual Time Estimation
---
## Actual Time Estimation

Actual Time Estimation is the process of predicting the most realistic amount of effort (expressed in terms of person-hours or money) required to develop or maintain software based on incomplete, uncertain and noisy input. Effort estimates may be used as input to project plans, iteration plans, budgets, investment analyses, pricing processes and bidding rounds.

### State-of-practice

Published surveys on estimation practice suggest that expert estimation is the dominant strategy when estimating software development effort.

Typically, effort estimates are over-optimistic and there is a strong over-confidence in their accuracy. The mean effort overrun seems to be about 30% and not decreasing over time. For a review of effort estimation error surveys, see. However, the measurement of estimation error is problematic, see Assessing the accuracy of estimates. The strong overconfidence in the accuracy of the effort estimates is illustrated by the finding that, on average, if a software professional is 90% confident or “almost sure” to include the actual effort in a minimum-maximum interval, the observed frequency of including the actual effort is only 60-70%.

Currently, the term “effort estimate” is used to denote different concepts, most likely the use of effort (modal value), the effort that corresponds to a probability of 50% of not exceeding (median), the planned effort, the budgeted effort or the effort used to propose a bid or price to the client. This is believed to be unfortunate, because communication problems may occur and because the concepts serve different goals.

### History

Software researchers and practitioners have been addressing the problems of effort estimation for software development projects since at least the 1960s; see, e.g., work by Farr and Nelson.

Most of the research has focused on the construction of formal software effort estimation models. The early models were typically based on regression analysis or mathematically derived from theories from other domains. Since then, a high number of model building approaches have been evaluated, such as approaches founded on case-based reasoning, classification and regression trees, simulation, neural networks, Bayesian statistics, lexical analysis of requirement specifications, genetic programming, linear programming, economic production models, soft computing, fuzzy logic modeling, statistical bootstrapping, and combinations of two or more of these models. 

Perhaps the most common estimation methods today are the parametric estimation models COCOMO, SEER-SEM and SLIM. They have their basis in estimation research conducted in the 1970s and 1980s and are since then updated with new calibration data, with the last major release being COCOMO II in the year 2000. The estimation approaches based on functionality-based size measures, e.g., function points, is also based on research conducted in the 1970s and 1980s, but are re-calibrated with modified size measures and different counting approaches, such as the use case points or object points in the 1990s and COSMIC in the 2000s.

Actual time estimation is a time-based method of estimating development work.  

It is critically important to be able to estimate the time-to-completion of an Agile project, unfortunately, it is also one of the most difficult parts of planning an Agile project. 

Its intent is to best approximate the amount of time required to complete a given development task. 

One technique you may use is to estimate the time it will take to complete user stories. When you are doing this, remember to consult with other members of your agile team. For each user story, make sure that you estimate a time that is realistic and feasible, yet not so much that the client is overcharged for simple work. Consult members of your team so that you may be able to leverage their expertise to be able to understand how much work is required and how long it will take. When you have a consensus for each user story, you can add up the times to come up with a time estimation. 

As the requirements of the project change over time, you can update the estimate. If a project loses some resources originally allocated to it, you may need to cut user stories to be able to complete them in the same amount of total time. Similarly, if you want to improve the quality of the app, you may need to allocate more time to each user story to make sure your team has time to finish the app with the desired quality.

Generally, these estimates are calculated using ideal engineering hours.

Examples: 

**This task will be complete in 10 days.**

Or… 

**This task will be completed by January 10th.**

Or… 

**This task will require 25 development hours for completion.**

### More Information:

- [Agile Constraints](http://www.brighthubpm.com/agile/50212-the-agile-triangle-value-quality-and-constraints/) 

- [How do you estimate on an Agile project?](http://info.thoughtworks.com/rs/thoughtworks2/images/twebook-perspectives-estimation_1.pdf)  
- [The secrets behind story points and agile estimation](https://www.atlassian.com/agile/project-management/estimation)

My addition
-[The Theory of Constraints in Agile](https://www.leadingagile.com/2018/03/the-theory-of-constraints-in-agile/)

