---
title: Application Lifecycle Management
---
## Application Lifecycle Management

Application Lifecycle Management (ALM), while commonly associated with Software Development Lifecycle (SDLC) is a broader perspective that aligns better with the concept of Product Lifecycle. The development (SDLC) is only a portion of the Application's Lifecycle and therefore is represented as part of the ALM. 

ALM can be divided into three distinct areas: Governance, Development, and Operations:

1. Governance: Encompasses all of the decision making and project management for this application, extends over the entire existence of the application.

2. Development: Process (SDLC) of actually creating the application. For most applications, the development process reappears again several more times in the application’s lifetime, including bug fixes, improvements and new versions.

3. Operations: Work required to run and manage the application,typically begins shortly before deployment, then runs continuously until application retirement. Overlaps at times with Development.  

Tools can be used to manage ALM; some of the more popular options include:

* Atlassian [JIRA](http://atlassian.com/software/jira)
* CA Technologies [Rally](http://ca.com/us.html)
* [Thoughtworks](http://thoughtworks.com/products)

#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
InfoQ - Gartner and Software Advice examine [Agile Lifecycle Management Tools](http://www.infoq.com/news/2015/02/agile-management-tools/)


