---
title: Burndown Charts and Burnup Charts
---
## Burndown Charts and Burnup Charts

Burndown and burnup charts are used to measure progress of a project-- usually a development sprint under the Agile methodology. Both charts visually represent work versus time. 

Burndown charts show how much work is left to be done versus the amount of time remaining. The Y axis represents work left to be done-- usually relating to a time estimate assigned to each task, e.g. story points-- and the X axis represents time left. Two lines are used; the first-- "Ideal Work Remaining Line"-- represents an ideal burndown, where each day an amount of work proportional to the total amount of time is completed, resulting in a straight line. The second "Actual Work Remaining Line" is used to plot actual progress as tasks move through development to a done state. An example of a burndown chart is shown below.

![alt text](https://upload.wikimedia.org/wikipedia/commons/8/8c/Burn_down_chart.png "Image Source: Wikipedia")

Many Scrum Teams use burndown charts in order to see how they are doing during the sprint. Having an even and steady burndown might be an indicator that the stories are small and manageable. If a team notices in the middle of a sprint that the "Actual Work Remaining Line" is above the "Ideal Work Remaining Line" they can make adjustments to the scope: stories can be taken out of the sprint or the scope of stories can be made smaller. Looking at the burndown during the retrospective in the end of the sprint might spark some interesting discussions and result in process improvements.

Burnup charts are very similar, but they show the work that has been completed versus the total amount of work and time remaining. Three lines are used-- an ideal line, a completed work line, and a total work line. In this chart, the total work line should be somewhat steady across the top of the chart, and is a good representation of scope change. The completed work line should move steadily up towards the total work line for the amount of time in the project-- its ideal trajectory is shown by the ideal line. An example is shown below.

![alt text](https://media.licdn.com/mpr/mpr/shrinknp_800_800/AAEAAQAAAAAAAAljAAAAJGQ1ZDI2NzRkLWExYTQtNGI2OS1hZmZjLTM1NGMzYTk1NTEyNg.png "Image Source: Ala'a Elbeheri, LinkedIn")


#### More Information:
<a href='https://en.wikipedia.org/wiki/Burn_down_chart' target='_blank' rel='nofollow'>Burndown Charts- Wikipedia</a>
<a href='https://www.linkedin.com/pulse/burn-up-vs-down-chart-alaa-el-beheri-cisa-rmp-pmp-bcp-itil/' target='_blank' rel='nofollow'>Burn up vs burn down chart- LinkedIn</a>


