---
title: Chickens Versus Pigs
---
## Chickens Versus Pigs

"Chickens versus Pigs" refers to a story about a chicken and a pig, where the chicken proposes they open a restaurant called "Ham-n-Eggs".
The pig refuses because the chicken just needs to lay eggs, while the pig has more at stake.

In an Agile software development project, the software developer is the pig. If you fail to complete the job, or fail to do it well,
you have a lot at stake. This could be your reputation, or maybe even your position. Other team members might also be considered pigs, 
depending on how much they have at stake. Pigs work together to complete the job.

On the other hand, many team members are chickens. For example, the client or a high-level project manager would not really be impacted
by the failure of the project. They are interested in its success, and might make contributions, but have less at stake and thus
have significantly less commitment to the project. 

A common situation to refer to this metaphor is when talking about the daily scrum meeting. Pigs are encouraged to contribute to the meeting because they need to collaborate in order to achieve the common goal and will be held accountable in case it's not reached. Stakeholders however are asked to be silent if they happen to attend the meeting. 

Another classic situation is when talking about estimations. Estimations must only be provided by the the developers who actually perform the work and will be held accountable if the estimations are not correct.  

You should strive to be a pig rather than a chicken. You can benefit from (but should not rely on) the chickens in order to minimize risk and
guarantee the project is delivered as efficiently as possible. Chickens often provide guidance to assure that right job is being done and that the copmpleted job will provide value.

#### More Information:
<a href='http://www.agilejedi.com/chickenandpig'>Agile Jedi: The Story of the Chicken and Pig</a>  
<a href='https://en.wikipedia.org/wiki/The_Chicken_and_the_Pig'>Wikipedia: The Chicken and the Pig</a>
