---
title: Continuous Deployment
---

## Continuous Deployment

Continuous Deployment is a modern software engineering process which is considered part of a DevOps environment. It involves teams of developers producing, updating and releasing code in very short cycles. This means developers commit smaller amounts of code, much more often.

The goal of Continuous Deployment is to have code in a constant reliable and deployable state to enable this code to be released at any time. This process aims to release code more quickly. To achieve continuous deployment, a development team relies on infrastructure that automates and instruments the various steps leading up to deployment. This is quite often called Infrastructure as Code (IaC). 

Two main benefits of Continuous Deployment include an earlier return on investment for each feature after it is developed due to the lower release times as well as earlier feedback on new features. 

Other benefits to Continuous Deployment include improved code quality due to less bugs making it to production, more reliable code releases and a much lower time to market.

