---
title: Daily Stand-Up and Daily Scrum
---
## Daily Stand-Up and Daily Scrum

The Daily Stand-Up (DSU) or Daily Scrum meeting is one of the integral parts of scrum methodology. The DSU helps the development team to keep track of the progress made towards accomplishing the sprint goal. 

As the name suggests, teams hold the meeting daily, at the same time and, for a co-located team, in the same location. Team members are encouraged to "stand up" for the duration of the meeting to keep the meeting brief (less than 15 minutes). 

Only members of the Development team are required to attend the Daily Stand-up. Typically, the Scrum Master and Product Owners will also attend, but they are not required. The Scrum Master may facilitate the stand-up meeting as needed, and the Product Owners and any management that may attend should only listen. 

The standard agenda for each developer is:
* What have you done since the last DSU
* What are you doing after this DSU
* What are the major obstacles (blockers) that are stopping your progress, and where do you need help
* Who can help you if you need help

Team members are to listen carefully to each other's contributions and attempt to identify areas where they can assist each other's progress. The standup meeting will also surface more lengthy topics of discussion that need to take place between different members of the team. These lengthier discussions that arise should then be halted and taken outside of the standup, involving only the relevant participants, and not the entire team.  After the standup meeting, team meetings can confer with the Product Owner and/or other resources to resolve issues identified during the stand-up meeting.

### More Information:
- [Wikipedia - Stand-up meeting](https://en.wikipedia.org/wiki/Stand-up_meeting)
- [YouTube - Example of stand-up meeting](https://www.youtube.com/watch?v=_3VIC8u1UV8)
- [blossom.co - 3 Tips for a Successful Stand-Up Meeting](https://www.blossom.co/blog/3-tips-for-quick-effective-stand-up-meetings)
