---
title: Design Patterns
---
## Design Patterns
A design pattern is a common design solution to a common design problem. A collection of design patterns for a related field or domain is called a pattern language. Note that there are also patterns at other levels: code, concurrency, architecture, interaction design, ect...

In software engineering, a software design pattern is a general reusable solution to a reoccurring problem within a given context in software design. It is not a finished design that can be transformed directly into source or machine code. It is a description or template for how to solve a problem that can be used in many different situations. Design patterns are formalized best practices that the programmer can use to solve common problems when designing an application or system.

Object-oriented design patterns typically show relationships and interactions between classes or objects, without specifying the final application classes or objects that are involved. Patterns that imply mutable state may be unsuited for functional programming languages, some patterns can be rendered unnecessary in languages that have built-in support for solving the problem they are trying to solve, and object-oriented patterns are not necessarily suitable for non-object-oriented languages.

Design patterns may be viewed as a structured approach to computer programming intermediate between the levels of a programming paradigm and a concrete algorithm.

The book that popularised the field is "Gang of Four's" (GoF) **Design Patterns: Elements of Reusable Object-Oriented Software** (1994). It present a series (23) of patterns for an conventional (C++) OO language classified in three types:
* **Creational** (to create objects): abstract factory, builder, factory method, prototype, singleton.
* **Structural** (to compose objects): adapter, bridge, composite, decorator, facade, flyweight, proxy.
* **Behavioral** (to communicate between objects): chain of responsibility, command, interpreter, iterator, mediator, memmento, observer, state, strategy, template method, visitor.

Patterns can be used for multiple objectives  (learning, communication, improving your tooling) but in agile they should be refactored from code with technical debt and not just added at the start (emergent design/architecture) as initially you don't have enough knowledge about the (future) system that is going to evolve. Note that what requires a pattern in a language or tool may not be needed or already be part of another language or tool. A framework is a set of cooperating classes that make up a reusable design for a specific type of software and are typically pattern-heavy.


#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
- [Wikipedia on Design Patterns](https://en.wikipedia.org/wiki/Software_design_pattern)
- [Wikipedia on GoF Book](https://en.wikipedia.org/wiki/Design_Patterns)
- [Design Patterns by Source Making](https://sourcemaking.com/design_patterns): list of well known patterns available online
- [Game Programming Patterns](http://gameprogrammingpatterns.com/): book about Design Patterns commonly used in Game Development, available to be read online for free
- [Object Oriented Design](http://www.oodesign.com/)
- [A Beginner’s Guide to Design Patterns](https://code.tutsplus.com/articles/a-beginners-guide-to-design-patterns--net-12752)
- [From design patterns to category theory](http://blog.ploeh.dk/2017/10/04/from-design-patterns-to-category-theory/)

