---
title: DSDM
---
## DSDM

DSDM stands for Dynamic Systems Development Method.  It is an Agile rapid development methodology, and aims to address the ongoing problem of the length of time it takes to develop information systems.  DSDM is more of a framework than a tightly-defined method, and much of the detail of how things should actually be done is left to the software development organisation or individual to decide.  DSDM adopts an incremental approach and uses the RAD (rapid application development) concept of timeboxing.  It also emphasizes the key role of people in the development process and is described as a user-centred approach.

DSDM has 9 core principles, as follows:

1) Active user involvement is imperative.
2) Teams must be empowered to make decisions.  The four key variables of empowerment are: authority, resources, information, and accountability.
3) Frequent delivery of products is essential.
4) Fitness for business purpose is the essential criterion for acceptance of deliverables.
5) Iterative and incremental development is necessary to converge on an accurate business solution.
6) All changes during development are reversible (ie you do not proceed further down a particular path if problems are encountered; you backtrack to the last safe or agreed point, and then start down a new path).
7) Requirements are baselined at a high level (ie the high-level business requirements, once agreed, are frozen).  This is essentially the scope of the project.
8) Testing is integrated throughout the life cycle (ie test as you go rather than testing just at the end where it frequently gets squeezed).
9) A collaborative and co-operative approach between all stakeholders is essential.

The 5 main phases of the DSDM development cycle are:

1) Feasibility study.
2) Business study.
3) Functional model iteration.
4) System design and build iteration.
5) Implementation.  

#### More Information:
You can read the following links to find out more.
- <a href='https://www.agilebusiness.org/what-is-dsdm'> Agile Business - What is DSDM?
- <a href='https://en.wikipedia.org/wiki/Dynamic_systems_development_method'> Wikipedia - Dynamic Systems Development Method

