---
title: Five Levels of Agile Planning
---
## Five Levels of Agile Planning

A product owner needs to be familiar with the five levels of agile planning:
  - Defining the product vision
  - Defining the product roadmap
  - Release planning
  - Sprint planning
  - Accounting for the outcome of daily scrums
  
Agile planning is always continuous and should be revised at least every three months.

## Brief Synopsis of the Five Levels of Agile Planning

 1. Product Vision: What (Summary of the major benefits & features the product will provide), Who (Stakeholders), Why (Need & Opportunity), When (Project scheduling & time expectations), Constraints and Assumptions (impacts risk & cost). The product vision should remain very high level and be easy to describe.
 
 2. Product Roadmap: Releases - Date, Theme/Feature Set, Objective, Development Approach. The product roadmap is a key tool in driving the priority of user stories in the development backlog.
 
 3. Release Planning: Iteration, Team Capacity, Stories, Priority, Size, Estimates, Definition of Done. When necessary, it is more common for the scope of a release to change, rather than the release date.
 
 4. Sprint Planning: Stories - Tasks, Definition of Done, Level-of Effort, Commitment. This level of planning is driven by the Scrum development team members. Only the development team can determine what items are pulled from the product backlog to the sprint backlog. This is based on team capacity and level of complexity of the backlog items.
 
 5. Daily Planning: What did I do yesterday? What will I do today? What is blocking me? This daily meeting keeps the team on track to accomplish the sprint goal, and over time, bring the product vision in to reality. 

### Visual Representation

![12-col-grid](https://www.scrumdesk.com/wp-content/uploads/5-levels-of-agile-planning.jpg)

#### More Information

[Scaling Agile Processes: Five Levels of Agile Planning](https://www.pragmaticmarketing.com/resources/articles/scaling-agile-processes-five-levels-of-planning)
