---
title: Agile
---
## Agile

Agile software development is a collection of methodologies used to manage teams of developers. It advocates adaptive planning, evolutionary development, early delivery, continuous improvement, and it encourages rapid and flexible response to change. People and communication are considered more important than tools and processes.

Agile emphasizes asking end users what they want, and frequently showing them demos of the product as it is developed. This stands in contrast to the "Waterfall" approach, specification-driven development, and what Agile practitioners call "Big Up-Front Design". In these approaches the features are planned out and budgeted before development starts. 

With Agile the emphasis is on "agility" - being able to quickly respond to feedback from users and other changing circumstances.

The agile software development places its emphasis on four core values:
1. Preference on team and individual interactions over tools and processes.
2. A working software over exhaustive documentation.
3. Collaboration with customer is given more importance than contract negotiations.
4. Response to changes over following a plan.

There are many different flavors of Agile, including Scrum and Extreme Programming.

![Various methods present in Agile testing or Agile Testing Methodologies](https://www.guru99.com/images/11-2014/agile_Processesv1_2.png)

### More information

- [Agile Alliance's Homepage](https://www.agilealliance.org/)
- [dummies.com - Agile cheat sheet](https://www.dummies.com/careers/project-management/agile-project-management-for-dummies-cheat-sheet/)
- [altexsoft.com - Project Management best practices](https://www.altexsoft.com/whitepapers/agile-project-management-best-practices-and-methodologies/)
- [agilemethodology.org](http://agilemethodology.org/)
- [A Beginners Guide To Understanding The Agile Method](https://linchpinseo.com/the-agile-method/)
- [zenkit.com - Agile methodology overview](https://zenkit.com/en/blog/agile-methodology-an-overview/)
- [Agile methodology - Visual](https://blog.capterra.com/wp-content/uploads/2016/01/agile-methodology.png)

