---
title: Integration Hell
---

## Integration Hell
Integration Hell is a slang term for when all the members of a development team go through the process of implementing their code at random times with no way to incorporate the different pieces of code into one seamless string of code. The development team will have to spend several hours or days testing and tweaking the code to get it all to work.

In practice, the longer components are developed in isolation, the more the interfaces tend to diverge from what is expected. When the components are finally integrated at the end of the project, it would take a great deal more time than allocated, often leading to deadline pressures and difficult integration. This painful integration work at the end of the project is the eponymous hell.

Continuous Integration is the idea that a development team should use specific tools to "continously integrate" the parts of the code they are working on multiple times a day so that the tools can match the different "chunks" of code together to integrate much more seamlessly than before.

Code Repositories, like Git (and its open source interface we all know and love, GitHub) allow development teams to organize their efforts so that more time can be spent coding and less time on worrying if the different parts of the code will all integrate.

<a href='https://guide.freecodecamp.org/agile/continuous-integration/'>Continuous Integration</a> is the Agile antidote to this problem. Integration is still painful, but doing it at least daily keeps interfaces from diverging too much.

#### More Information:
- <a href='https://tobeagile.com/2017/03/08/avoiding-integration-hell/'>Avoiding Integration Hell</a>
- <a href='http://wiki.c2.com/?IntegrationHell'>Integration Hell</a>
- <a href='https://www.apicasystems.com/blog/top-5-tips-avoid-integration-hell-continuous-integration/'>Top 5 Tips to Avoid “Integration Hell” with Continuous Integration</a>
- <a href="https://dzone.com/articles/continuous-integration-how-0">D-Zone article on Integration Hell and how Continous Integration has help make it almost a thing of the past</a>
