---
title: Lean Software Development
---
## Lean Software Development

### Introduction

Lean Software Development is the process of building software with the focus on using techniques which minimize extra work and wasted effort. These techniques are borrowed from the Lean manufacturing movement and applied to the context of software development.

### Key Concepts

There are seven principles within the methodology which include:
  1. Eliminate waste
  2. Amplify learning
  3. Decide as late as possible
  4. Deliver as fast as possible
  5. Empower the team
  6. Build integrity in
  7. See the whole

### Metaphors

The act of programming is viewed as an assembly line, where every feature or bug fix is called a "change request". This assembly line of "change requests" can then be considered as a "value stream" with the goal being to minimize the time that each "change request" is on the line prior to being delivered.

Software which is not yet delivered is considered as "inventory" since it has not yet provided value to the company or the customer. This includes any software which is partially complete. Therefore to maximize throughput it is important to deliver many small complete working pieces of software.

In order to minimize the "inventory" it is important to secede control to the "workers" who would be the software developers, as they would be best equipped to create automated processes to "mistake proof" the various parts of the assembly line.

### References

The original source of written documentation on the Lean techniques is the book Lean Software Development, An Agile Toolkit by Mary and Tom Poppendieck.

Additional books by the author(s) include:
  - Implementing Lean Software Development: From Concept to Cash by Mary Poppendieck
  - Leading Lean Software Development: Results Are not the Point by Mary Poppendieck
