---
title: Moscow
---
## Moscow 

## MoSCoW Method

One of the meaning of this word is the MoSCoW method - a prioritization technique used in management, business analysis, project management, and software development to reach a common understanding with stakeholders on the importance they place on the delivery of each requirement - also known as MoSCoW prioritization or MoSCoW analysis.

## Prioritization of MoSCoW requirements

All requirements are important, but they are prioritized to deliver the greatest and most immediate business benefits early. Developers will initially try to deliver all the Must have, Should have and Could have requirements but the Should and Could requirements will be the first to be removed if the delivery timescale looks threatened.

The plain English meaning of the prioritization categories has value in getting customers to better understand the impact of setting a priority, compared to alternatives like High, Medium and Low.

The categories are typically understood as:

## Must have
    Requirements labeled as Must have are critical to the current delivery timebox in order for it to be a success. If even one Must have requirement is not included, the project delivery should be considered a failure. MUST can also be considered an acronym for the Minimum Usable SubseT.

## Should have
    Requirements labeled as Should have are important but not necessary for delivery in the current delivery timebox. While Should have requirements can be as important as Must have, they are often not as time-critical or there may be another way to satisfy the requirement, so that it can be held back until a future delivery timebox.

## Could have
    Requirements labeled as Could have are desirable but not necessary, and could improve user experience or customer satisfaction for little development cost. These will typically be included if time and resources permit.

## Won't have
    Requirements labeled as Won't have have been agreed by stakeholders as the least-critical, lowest-payback items, or not appropriate at that time. As a result, Won't have requirements are not planned into the schedule for the next delivery timebox. Won't have requirements are either dropped or reconsidered for inclusion in a later timebox. 

MoSCoW is a coarse-grain method to prioritise (categorise) Product Backlog Items (or requirements, use cases, user stories ... depending on the methodology used).
MoSCoW is often used with timeboxing, where a deadline is fixed so that the focus must be on the most important requirements. 
The term MoSCoW itself is an acronym derived from the first letter of each of four prioritization categories (Must have, Should have, Could have, and Won't have):

* **Must have**: Critical to the current delivery timebox in order for it to be a success. It is typically part of the MVP (Minimum Viable Product).
* **Should have**: Important but not necessary for delivery in the current delivery timebox. 
* **Could have**: Desirable but not necessary, an improvement.
* **Won't have**: Least-critical, lowest-payback items, or not appropriate at this time.

By prioritizing in this way, a common definition of the project can be reached and stakeholders' expectations set accordingly. Note That MoSCoW is a bit lax about how to distinguish the category of an item and when something will be done, if not in this timebox.

#### More Information:

[Wikipedia](https://en.wikipedia.org/wiki/MoSCoW_method)

