---
title: Nonfunctional Requirements
---
## Nonfunctional Requirements

A non-functional requirement (NFR) is a requirement that specifies criteria that can be used to judge the operation of a system, rather than specific behaviors (a functional requirement). Non-functional requirements are often called "quality attributes", "constraints" or "non-behavioral requirements". 

In plain English, non-functional requirements are things that 100% is needed for the code to run. For example, a requirement would be to be able to login, but whether it takes 1 second to log in or 1 hour to login, both satisfy the functional requirement. The non-functional requirement would then be that the login time should take no more than 3 seconds. 

Informally, these are sometimes called the "ilities", from attributes like stability and portability. NFRs can be divided into two main categories:
* **Execution qualities**, such as safety, security and usability, which are observable during operation (at run time).
* **Evolution qualities**, such as testability, maintainability, extensibility and scalability, which are embodied in the static structure of the system

Usually you can refine a non-functional requirement into a set of functional requirements as a way of detailing and allowing (partial) testing and validation.

### Examples:

* The printer should print 5 seconds after the button is pressed
* The code should be written in Java
* The UI should be easily navigable

#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
* [Wikipedia article](https://en.wikipedia.org/wiki/Non-functional_requirement)
* [ReQtest](http://reqtest.com/requirements-blog/functional-vs-non-functional-requirements/) Explains the difference between functional and nonfunctional requirements
* [Scaled Agile](http://www.scaledagileframework.com/nonfunctional-requirements/) Works through the process from finding to testing nonfunctional requirements


