---
title: Planning Poker
---
## Planning Poker

### Introduction
Planning poker is an estimation and planning technique in the Agile development model. It is used to estimate the development effort  required for a [user story](../user-stories/index.md) or a feature. 

### Process
The planning poker is done for one user story at a time.

Each estimator holds an identical set of poker cards consisting of cards with various values. The card values are usually from the [Fibonacci Sequence](https://en.wikipedia.org/wiki/Fibonacci_number). The unit used for the values can be the number of days, story points, or any other kind of estimation unit agreed on by the team.

The product owner (PO) or stakeholder explains the story that is to be estimated.

The team discusses the story, asking any clarifying questions that they might have. This helps the team get a better understanding on *what* the PO wants. 

At the end of the discussion, each person first selects a card (representing their estimate for the story) without showing it to the others. Then, they reveal their cards at the same time.

If all the cards have the same value, the value becomes the estimate for the story. If there are differences, the team discusses the reasons for the values that they have chosen. It is of high value that the team members who gave the lowest and highest estimates provide justifications for their estimates. 

After this discussion, the process of picking a card in private and then revealing it at the same time is repeated. This is done until there is a consensus on the estimate.

Because planning poker is a tool to moderate a *joint* expert estimation, it leads to a better common understanding and perhaps even refinement of the feature request. It is of high value even when the team is operating in a No-Estimates mode. 

A moderator should try to avoid confirmation bias. 

Things worth mentioning:
- Estimations are not comparable between teams, as every team has its own scala.
- Estimations should include everything that needs to be done in order for a piece of work to be done: designing, coding, testing, communicating, code reviews (+ all possible risks)
- The value of using planning poker is in the resulting discussions, as they reveal different views on a possible implementation

### More Information:
- Planning poker video: <a href='https://www.youtube.com/watch?v=MrIZMuvjTws' target='_blank' rel='nofollow'>YouTube</a>
