---
title: Product Management
---
## Product Management

Product Management is an organizational function that assumes responsibility for the entire lifecycle of the products that are being sold. As a business function, Product Management is held accountable for creating customer value and measurable benefits to the business. 

There are a few core responsibilities common to most product management roles inside both established enterprise companies and at startups. Most often, product management is responsible for understanding customer requirements, defining and prioritizing them, and working with the engineering team to build them. Setting strategy and defining the roadmap is often considered to be inbound work and bringing the product to market is often considered to be "outbound."

It is important to understand the differences between inbound and outbound product management because a great product manager has the diverse set of skills to do both well. 

The difference between Product Management and Project Management relates to the scale and life cycle. Project Managers ensure multiple products/services/projects are delivered to a customer, while Product Managers go beyond development and work towards longevity and operation of a product/service.

In Game development we can see the clear shift from Projects to Products due to games having more detailed post launch plans and monetization strategies.

### Inbound Product Management

Inbound product management involves gathering customer research, competitive intelligence, and industry trends, as well as setting strategy and managing the product roadmap.

Product Strategy and Definition (Inbound)

- Strategy and vision
- Customer interviews
- Defining features and requirements
- Building roadmaps
- Release management
- Go-to-resource for engineering
- Sales and support training

### Outbound Product Management

Outbound product management involves product marketing responsibilities such as: messaging and branding, customer communication, new product launches, advertising, PR, and events. Depending on the organization, these roles can be performed by the same person or two different people or groups that work closely together.

Product Marketing and Go-to-Market (Outbound)

- Competitive differentiation
- Positioning and messaging
- Naming and branding
- Customer communication
- Product launches
- Press and analyst relations

### Product Manager

Product management continues to expand as a profession. Demand for qualified product managers is growing at every level. There are a variety of roles and responsibilities depending on experience level. Opportunities range from an Associate Product Manager all the way to CPO.

Most Product Managers have been in different roles earlier in their careers. Very often software engineers, sales engineers, or professional services consultant grow into the role of Product Manager. However, in some companies (e.g. Google, Facebook, etc.), junior Product Managers are recruited straight out of school and supported by career programs that teach them while on the job.   

#### More Information
- [Wikipedia](https://en.wikipedia.org/wiki/Product_management)
- [Product Management Overview](https://www.atlassian.com/agile/product-management)


