---
title: Product Owners
---
## Product Owners

Product Owners lead the product vision and release planning. They are in charge of defining the features, the release date, and the content that makes up a shippable product. The goal of a Product Owner is to build the right thing quickly and correctly. In organizations that have both a product manager as well as a product owner, the product owner works more closely with the development teams while the product manager works as the voice of the customer.

At a high-level, the Product Owner is responsible for the following:

* Owner of the product vision
* Leads release planning
* Defines features and content of the release
* Manages team's understanding of the release
* Creates and curates the product backlog
* Prioritizes the product backlog
* Guides team through the release cycle
* Makes trade-off decisions
* Accepts or rejections work

The Product Owner creates a backlog of items that they think would make a good product. This knowledge is based on their understanding of the market, user testing, and market projection. Product Owners adjust the long-term goals of the product based on the feedback they receive from users and stakeholders. They also act as the point of contact with stakeholders and manage scope and expectations. 

Once the Product Owner has received feedback from the various stakeholders, they then refine the backlog to add as much detail as possible in order to create a Minimum Viable Product (MVP)for that release.

The Product Owner then prioritizes the workload to ensure that the stories that are completed address both business value and user goals. Also, if there are risks associated with certain stories, the Product Owner puts those at the top of the backlog so that the risks are addressed early.

Working with the team and the Scrum Master, the Product owner attends sprint planning meetings to loop groomed stories into the sprint. Throughout the sprint, the Product Owner ensures that the team completes the work according to the Definition of Done (DoD), answers any questions that may arise, and update stakeholders. 

When the sprint is complete, the Product Owner participates in the Sprint Review along with other stakeholders. Making sure that each story meets the DoD, the Product Owner prepares for the next sprint by gathering feedback and prioritizing work based on what was completed. 


### More Information:
- Agile Product Ownership in a Nutshell video: [YouTube](https://www.youtube.com/watch?v=502ILHjX9EE)

