---
title: Rapid Application Development
---
## Rapid Application Development

Rapid Application Development (RAD) was devised as a reaction to the problems of traditional software development methodologies, particularly the problems of long development lead times.  It also addresses the problems associated with changing requirements during the development process.  

The main principles of RAD are as follows:
1) Incremental development. This is the main means by which RAD handles changing requirements.  Some requirements will only emerge when the users see and experience the system in use. Requirements are never seen as complete - they evolve over time due to changing circumstances.  The RAD process starts with a high-level, non-specific list of requirements which are refined during the development process.
2) Timeboxing.  With timeboxing, the system is divided up into a number of components or timeboxes that are developed separately. The most important requirements are developed in the first timebox. Features are delivered quickly and often.
3) The Pareto principle. Also known as the 80/20 rule, this means that around 80% of a system's functionality can be delivered with around 20% of the total effort needed. Therefore, the last (and most complex) 20% of requirements take the most effort and time to deliver. So, you should choose as much of the 80% to deliver as possible within the first few timeboxes.  The rest, if it proves necessary, can be delivered in subsequent timeboxes.
4) MoSCoW rules. MoSCoW is a method used for prioritising work items in software development. Items are ranked as Must Have, Should Have, Could Have or Would Like to Have. Must Have items are those which must be included in a product for it to be accepted into release, with the other classifications in descending priority.
5) JAD workshops. Joint Application Development (JAD) is a facilitated meeting where requirements gathering is carried out, in particular interviewing users of the system to be developed. The JAD workshop usually takes place early on in the development process, although additional meetings can be organised if required later in the process.
6) Prototyping. Building a prototype helps to establish and clarify the user requirements, and in some cases it evolves to become the system itself.
7) Sponsor and champion. An executive sponsor is someone within the organisation who wants the system, is committed to achieving it and is prepared to fund it. A champion is someone, usually at a lower level of seniority than an executive, who is committed to the project and is prepared to drive it forward to completion.
8) Toolsets. RAD usually adopts toolsets as a means of speeding up the development process and improving productivity. Tools are available for change control, configuration management and code reuse.

#### More Information:
- https://en.wikipedia.org/wiki/Rapid_application_development - Wikipedia article on RAD
- https://www.tutorialspoint.com/sdlc/sdlc_rad_model.htm - TutorialsPoint tutorial on RAD


