---
title: SAFe
---
## SAFe

SAFe stands for "Scaled Agile Framework" and is an agile software development framework that is designed for large-scale agile development involving many teams.

The main website (<a target='_blank' rel='nofollow' href="http://www.scaledagileframework.com/">http://www.scaledagileframework.com/</a>) is an freely available online knowledge base on implementing SAFe.

## Principles

There are nine, underlying principles for SAFe

1. **Take an economic view** - evaluate economic costs of decisions, developments, and risks
2. **Apply systems thinking** - development processes are interactions among the systems used by workers and thus need to view progress with systems thinking
3. **Assume variability; preserve options** - requirements change, be flexible, and use empirical data to narrow focus
4. **Build incrementally with fast, integrated learning cycles** - fast, incremental builds allow rapid feedback in order to change the project if necessary
5. **Base milestones on objective evaluation on working systems** - objective evaluation provides important information such as financials and governance as feedback
6. **Visualize and limit WIP, reduce batch sizes, and manage queue lengths** - do these to achieve continuous flow to move quickly and visualize progress; WIP = work-in-progress
7. **Apply cadence, synchronize with cross-domain planning** - cadence is setting dates when certain events happen (e.g. release weekly) and synchronizing makes sure everyone has the same goals in mind
8. **Unlock the intrinsic motivation of knowledge workers** - people work better when you make use of their personal motivations
9. **Decentralize decision-making** - allows faster action, which may be not the best solution, but allows faster communication among teams; centralized decision-making may be necessary for more strategic or global decisions

## Configurations

There are four variations of SAFe, varying in complexity and needs of your project:

1. Essential SAFe
2. Portfolio SAFe
3. Large Solution SAFe
4. Full SAFe

#### More Information:

- <a href="https://en.wikipedia.org/wiki/Scaled_Agile_Framework" target="_blank" rel="nofollow">Scaled Agile Framework</a>
- <a href="http://www.scaledagileframework.com/what-is-safe/" target="_blank" rel="nofollow">What is SAFe?</a>
- <a href="http://www.scaledagileframework.com/essential-safe/" target="_blank" rel="nofollow">The Ten Essential Elements</a>
- <a href="http://www.scaledagileframework.com/safe-lean-agile-principles/" target="_blank" rel="nofollow">SAFe Principles</a>
