---
title: Scrum
---
## Scrum

Scrum is one of the methodologies under the Agile umbrella. The name is derived from a method of resuming play in the sport of rugby, in which the entire team moves together to make ground. Similarly, a scrum in Agile involves all parts of the team working on the same set of goals. In the scrum method, a prioritized list of tasks is presented to the team, and over the course of a "sprint" (usually two weeks), those tasks are completed, in order, by the team. This ensures that the highest-priority tasks or deliverables are completed before time or funds run out. 

### Components of a Scrum

Scrum is one of the methodologies under the Agile umbrella. It originates from 'scrummage' which is a term used in rugby to denote players huddling together to get possession of the ball.
The practice revolves around 

- A set of roles (delivery team, product owner, and scrum master)
- Ceremonies (sprint planning, daily standup, sprint review, sprint retrospective, and backlog grooming)
- Artifacts (product backlog, sprint backlog, product increment, and info radiators and reports).
- The main goal is to keep the team aligned on project progress to facilitate rapid iteration.
- Many organizations have opted for Scrum because unlike the Waterfall model, it ensures a deliverable at the end of each Sprint.

## Artifacts
- Sprint: It is the time duration, mostly in weeks, for which a Team works to achieve or create a deliverable. A deliverable can be defined as a piece of code or fragment of the Final Product which the team wants to achieve. Scrum advises to keep the duration of a Sprint between 2-4 weeks.
- Product Backlog: It is the list of tasks a Team is supposed to finish within the current Sprint. It is decided by the Product Owner, in agreement with the Management as well as Delivery Team.

## Roles
- Product Owner(PO): The ONLY Accountable person to the Management. PO decides what goes in or out of the Product Backlog.
- Delivery Team: They are required to work in accordance with the tasks set by their PO in the product backlog and deliver the required delivarable at the end of the sprint.
- Scrum Masters(SM): - Scrum Masters have to strictly adhere to the Scrum Guide and make the team understand the need to adhere to Scrum Guide when following Scrum. It is a Scrum Master's job to ensure all Scrum ceremonies being conducted on time and participated by all the required people as per the Scrum Guide. The SM has to ensure that the Daily Scrum is conducted regularly and actively participated by the team.


#### More Information:

There are several online tools that can be used to do scrum for your team:

- [Scrum Do](https://www.scrumdo.com/) 
- [Asana](http://www.asana.com)
- [Trello](http://trello.com)
- [Monday](https://monday.com)
- [Basecamp](https://basecamp.com)
- [Airtable](https://airtable.com)
- [SmartSheet](https://www.smartsheet.com)
- [JIRA](https://www.atlassian.com/software/jira)

Here are some more resources:

- [Why Scrum](https://www.scrumalliance.org/why-scrum) from The Scrum Alliance
- [Scrum Guide](http://www.scrumguides.org/scrum-guide.html) from Scrum.org
- [Doing vs Being Agile](http://agilitrix.com/2016/04/doing-agile-vs-being-agile/)
