---
title: Spikes
---
## Spikes

Not everything your team works on during the Sprint are User Stories. Sometimes, a user story cannot be effectively estimated or research is required. Maybe help is needed to decide between different architectures, to rule out some risks, or it may be a Proof of Concept (POC) to demonstrate a capability.

In these cases, a Spike is added to the Sprint Backlog. The Acceptance Criteria for the Spike should be an answer to the question being posed. If the experiment is more difficult than anticipated, then maybe the answer is negative (that's why the Spike should be limited in time). 

The time and energy invested in the Spike are intentionally limited so that the work can be completed within the Sprint while other User Stories are minimally impacted. The Spike does not usually receive a Story Point Estimate, but is given a fixed number of hours to be worked on.

Demonstrate the results of the Spike in the Sprint Review. Based on the new information, the original question is reframed as a new User Story in a future Sprint.

Your team gained the information necessary to make better decisions; to reduce uncertainty. With a small, measured amount of its resources to increase the quality and value of work in future Sprints, as opposed to making decisions based on guess-work.
<!-- The article goes here, in GitHub-flavored Markdown. Feel free to add YouTube videos, images, and CodePen/JSBin embeds  -->

#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
- Mountain Goat Software [Spikes](https://www.mountaingoatsoftware.com/blog/spikes)
- Scrum.org Forum [How to Integrate a Spike](https://www.scrum.org/forum/scrum-forum/5512/how-integrate-spike-scrum)
- Scrum Alliance [Spikes and Effort-to-Grief Ratio](https://www.scrumalliance.org/community/articles/2013/march/spikes-and-the-effort-to-grief-ratio)
- Wikipedia [Spike](https://en.wikipedia.org/wiki/Spike_(software_development))

