---
title: Sprint Planning Meeting
---
## Sprint Planning Meeting

The Sprint Planning is facilitated by the team's Scrum Master and consists of the Scrum Team: Development Team, Product Owner (PO), and Scrum Master (SM). It aims to plan a subset of Product Backlog items into a Sprint Backlog. The Scrum Sprint normally begins after the Sprint Planning meeting. 

### Main part

It is valuable for the team to divide the meeting into two parts by asking these questions: 

* **What** should the team plan for the upcoming Sprint? 
* **How** should the team (roughly) tackle the items planned?

#### What
In the What phase, the team starts with the top of the ordered Product Backlog. The team at least implicitly estimates the items by forecasting what they can move into the Sprint Backlog. If needed, they could ask questions and discuss items with the PO, who has to be in attendance for this meeting. 

#### How
In the How phase, the team briefly discusses each chosen Sprint Backlog item with a focus on how they will tackle it. The SM helps the team avoid diving too deeply into discussion and implementation details. Often, it is valuable for the PO to address more questions or make refinements to items, while the backlog is done by the team.

### Sprint Goal / Closing
The team should come up with a shared Sprint Goal for the Sprint to keep the focus in the Sprint time box. At the end of the Sprint Planning, the team forecasts that they can achieve the Sprint Goal and most likely complete all Sprint Backlog items. The SM should prevent the team from overestimating by providing useful insights or statistics.  


#### More Information
- [Scrum Guide: Sprint Planning](http://www.scrumguides.org/scrum-guide.html#events-planning)
- [Simple Cheat Sheet to Sprint Planning Meetings](https://www.leadingagile.com/2012/08/simple-cheat-sheet-to-sprint-planning-meeting/)
- [Four Steps for Better Sprint Planning](https://www.atlassian.com/blog/agile/sprint-planning-atlassian)
