---
title: Sprint Planning
---

## Sprint Planning

In Scrum, the sprint planning meeting is attended by the product owner, ScrumMaster and the entire Scrum team. Outside stakeholders may attend by invitation of the team, although this is rare in most companies.
During the sprint planning meeting, the product owner describes the highest priority features to the team. The team asks enough questions that they can turn a high-level user story of the product backlog into the more detailed tasks of the sprint backlog.

There are two defined artifacts that result from a sprint planning meeting:
- A sprint goal
- A sprint backlog

Sprint Planning is time-boxed to a maximum of eight hours for a one-month Sprint. For shorter Sprints, the event is usually shorter. The Scrum Master ensures that the event takes place and that attendants understand its purpose. The Scrum Master teaches the Scrum Team to keep it within the time-box. 

## The WHY behind Sprint Planning
The purpose of Sprint Planning meeting is to achieve the following goals:

* **Know the work** - The Team must first understand the scope of the highest business value items in product backlog. With this understanding they can choose which of these can be brought into the sprint based on their capacity. The team creates task for each of the items in sprint so that teammembers can volunteer for tasks as sprint progresses.

* **Get a Fresh Start** - No matter how the last sprint went either a sucess or not so successful. Sprint planning provies a fresh start a new beginning with a collective commitment from the team.

* **Commit to Shared Goals** - All the work that is commited for the sprint is committed collectively as a team and not as individuals and they jointly agree to achieve the sprint goal.

* **Create Focus and Abundance** - By choosing the right amount of work for the sprint based on past performances and current capacity of team, the team has created focus for themselves and a feels that "we have enough to do" for this time box.

#### More Information:
* https://www.mountaingoatsoftware.com/agile/scrum/meetings/sprint-planning-meeting
* [Scrum Guide](https://www.scrumguides.org/scrum-guide.html#events-planning)
