---
title: Sprints
---
## Sprints

In Scrum, the **Sprint** is a period of working time usually between one and four weeks in which the delivery team works on your project. Sprints are iterative, and continue until the project is completed. Each sprint begins with a Sprint Planning session, and ends with Sprint Review and Retrospective meetings. Using sprints, as opposed to months-long waterfall or linear sequential development methodologies, allows regular feedback loops between project owners and stakeholders on the output from the delivery team.

## Properties of a Sprint
- A sprint should not be terminated prematurely if at all possible. If the stories within the sprint become obsolete, the team may decide to close them and pull new stories off of the product backlog.
- The team works to break up the User Stories, a non-technical description of what the user expects to see and/or do, to a size that can be completed within the duration of the Sprint without carrying over to the next. 
- "Sprint" and "Iteration" are often used interchangeably.

#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
- Agile Alliance on <a href='https://www.agilealliance.org/glossary/iteration/' target='_blank' rel='nofollow'>Iterations</a>
- Agile Alliance on <a href='https://www.agilealliance.org/glossary/timebox/' target='_blank' rel='nofollow'>Timeboxes</a>
- Agile Coach on <a href='http://agilecoach.typepad.com/agile-coaching/2014/02/sprint-vs-iteration.html' target='_blank' rel='nofollow'>Sprint vs Iteration</a>
- Scrum Alliance <a href='https://www.scrumalliance.org/community/articles/2014/february/timeboxing-a-motivational-factor-for-scrum-teams' target='_blank' rel='nofollow'>Timeboxing as a Motivational Factor</a>
- Scrum Alliance <a href='https://www.scrumalliance.org/community/articles/2014/may/sprint-is-more-than-just-a-timebox' target='_blank' rel='nofollow'>Sprint is More Than Just a Timebox</a>
- Scrum Inc <a href='https://www.scruminc.com/what-is-timeboxing/' target='_blank' rel='nofollow'>What is Timeboxing</a>
- Scrum.org <a href='https://www.scrum.org/resources/what-is-a-sprint-in-scrum' target='_blank' rel='nofollow'>What is a Sprint in Scrum</a>
