---
title: Story Points and Complexity Points
---
## Story Points and Complexity Points

In Scrum/Agile, the functionality of a product in development is explored by way of **stories** a user might tell about what they want from a product. A team uses **Story Points** when they estimate the amount of effort required to deliver a user story.

Notable features of story points are that they:

* represent the contributions of the whole team
* do not equate directly to time the task might take
* are a rough measure for planning purposes - similar to orders of magnitude
* are assigned in a Fibonacci-like sequence: 0, 1, 2, 3, 5, 8, 13, 20, 40, 100
* estimate the 'size' of stories *relative to each other*

The concept of story points can be quite elusive if you are new to Agile ways of doing things. You will find many online sources discussing story points in different ways, and it can be hard to get a clear idea of what they are and how they are used.

As you learn about the principles and terminology of practices like Scrum, the reasons for some of these properties will become apparent. The use of story points, especially in 'ceremonies' such as planning poker, is much easier to understand by observing or taking part than in a written explanation!

### More Information:
- User Stories: <a href='https://guide.freecodecamp.org/agile/user-stories' target='_blank' rel='nofollow'>freeCodeCamp</a>
- Common mistakes when using story points: <a href='https://medium.com/bynder-tech/12-common-mistakes-made-when-using-story-points-f0bb9212d2f7' target='_blank' rel='nofollow'>Medium</a>
- Planning Poker: <a href='https://www.mountaingoatsoftware.com/agile/planning-poker' target='_blank' rel='nofollow'>Mountain Goat Software</a>
