---
title: Task Boards and Kanban
---
## Task Boards and Kanban
Kanban is an excellent method both for teams doing software development and individuals tracking their personal tasks.

Derived from the Japanese term for "signboard" or "billboard" to represent a signal, the key principal is to limit your work-in-progress (WIP) to a finite number of tasks at a given time. The amount that can be In Progress is determined by the team's (or individual's) constrained capacity. As one task is finished, that's the signal for you to move another task forward into its place.

Your Kanban tasks are displayed on the Task Board in a series of columns that show the state of the tasks. In its simplest form, three columns are used
- To Do
- Doing 
- Done

![Kanban Board Example](https://upload.wikimedia.org/wikipedia/commons/thumb/d/d3/Simple-kanban-board-.jpg/600px-Simple-kanban-board-.jpg)

*Image courtesy of <a href='https://en.wikipedia.org/wiki/Kanban_board' target='_blank' rel='nofollow'>Wikipedia</a>*

But many other columns, or states, can be added. A software team may also include Waiting to Test, Complete, or Accepted, for example.

![More Complicated Example](https://mktgcdn.leankit.com/uploads/images/general/_2048xAUTO_fit_center-center/1-SmalDevelopmentTeamKanbanBoard-eb79376d.png)

*Image courtesy of <a href='https://leankit.com/learn/kanban/kanban-board-examples-for-development-and-operations/' target='_blank' rel='nofollow'>leankit</a>*

### More Information:
- What is Kanban: <a href='https://leankit.com/learn/kanban/what-is-kanban/' target='_blank' rel='nofollow'>Leankit</a>
- What is Kanban: <a href='https://www.atlassian.com/agile/kanban' target='_blank' rel='nofollow'>Atlassian</a>

Some online boards
- <a href='https://trello.com/' target='_blank' rel='nofollow'>Trello</a>
- <a href='https://kanbanflow.com' target='_blank' rel='nofollow'>KanbanFlow</a>
