---
title: Technical Debt
---
## Technical Debt
Often in agile development, if you are producing software in the "good enough" practice, you will also be adding to your technical debt. This is the accumulation of short cuts and work-arounds.

Compare it to money. When you charge something on a credit card, you've made a commitment to pay it back later. When you create technical debt, your team *should* commit to addressing those issues on a schedule.

One of the benefits of working iteratively is to frequently showcase your increments and gather feedback. If your first pass is "good enough", and changes are required as a result of that feedback, you may have avoided some unnecessary work. Capture this in your backlog, and include a portion in each sprint to be refactored or improved.
<!-- The article goes here, in GitHub-flavored Markdown. Feel free to add YouTube videos, images, and CodePen/JSBin embeds  -->

#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
- The Agile Alliance on <a href='https://www.agilealliance.org/introduction-to-the-technical-debt-concept/' target='_blank' rel='nofollow'>Technical Debt</a>
- Scrum Alliance on <a href='https://www.scrumalliance.org/community/articles/2013/july/managing-technical-debt' target='_blank' rel='nofollow'>Managing Technical Debt</a>

