---
title: User Acceptance Tests
---
## User Acceptance Tests

In engineering and its various subdisciplines, acceptance testing is a test conducted to determine if the requirements of a specification or contract are met. It may involve chemical tests, physical tests, or performance tests.

In systems engineering it may involve black-box testing performed on a system (for example: a piece of software, lots of manufactured mechanical parts, or batches of chemical products) prior to its delivery.

In software testing the ISTQB defines acceptance as: formal testing with respect to user needs, requirements, and business processes conducted to determine whether a system satisfies the acceptance criteria and to enable the user, customers or other authorized entity to determine whether or not to accept the system. Acceptance testing is also known as user acceptance testing (UAT), end-user testing, operational acceptance testing (OAT) or field (acceptance) testing.

A smoke test may be used as an acceptance test prior to introducing a build of software to the main testing process.

One of the final steps in software testing is user acceptance testing (UAT). UAT makes sure actual users can use the software. Also referred to as beta, application, and end-user testing. 

UAT checks that everything works properly and that there are no crashes. Those of the intended audience should complete the testing; this could be comprised of many people involved from the process and anyone who is able to test before going live.  The feedback from this testing is forwarded to the development team for any specific changes.
  

#### Why do we need UAT

* Requirement changes might not have communicated to the developers

* The software may not be delivering actually what it meant for

* Some logic or business process may need user's attention


#### What is required before we start UAT

* Complete requriement is signed off and is available as documented

* The code is in working or in demoable condition

* UAT is environment is ready for access

* There should not be any defect which will break the code

* Test data prepared in accordance with the LIVE scneario
  

#### Framework & tools used

* FitNesse


#### Articles about UAT

* [7 KEYS TO A SUCCESSFUL USER ACCEPTANCE TESTING](http://blog.debugme.eu/successful-user-acceptance-testing/)

* [AgileUAT: A Framework for User Acceptance Testing
based on User Stories and Acceptance Criteria](http://research.ijcaonline.org/volume120/number10/pxc3903533.pdf)


#### More Information:
https://en.wikipedia.org/wiki/Acceptance_testing

