---
title: User Stories
---
User stories are part of an agile approach that helps shift the focus from writing about requirements to talking about them. All agile user stories include a written sentence or two and, more importantly, a series of conversations about the desired functionality.

User stories are typically written using the following pattern:
#### As a [ type of user ], I want [ some goal ] so that [ some reason or need ]

User stories should be written in non-technical terms from the perspective of the user. The story should emphasize the need of the user, and not the how. There should be no solution provided in the user story.

One common mistake that is made when writing user stories is writing from the perspective of the developer or the solution. Be sure to state the goal and the stakeholder need, and the functional requirements come later.

User stories are often written on sticky notes and put on walls where they are visible to the entire team. Alternatively, they can also be captured using story mapping or project management tools, such as StoriesOnBoard or JIRA.

#### Sizing a User Story: Epics and Smaller Stories
An epic is a big, coarse-grained story. It is typically broken into several user stories over time—leveraging the user feedback on early prototypes and product increments. You can think of it as a headline and a placeholder for more detailed stories.

Starting with epics allows you to sketch the product functionality without committing to the details. This is particularly helpful for describing new products and features: It allows you to capture the rough scope, and it buys you time to learn more about how to best address the needs of the users.

It also reduces the time and effort required to integrate new insights. If you have many detailed stories in the product backlog, then it’s often tricky and time-consuming to relate feedback to the appropriate items and it carries the risk of introducing inconsistencies.

When thinking about possible stories, it is also important to consider "mis-user cases" and "unhappy path" stories.  How will exceptions be handled by the system?  What kind of messaging will you provide back to user?  How would a malicious user abuse this application function?  These mal-stories can save rework and become useful test cases in QA.

#### More Information
- <a href='https://www.mountaingoatsoftware.com/agile/user-stories' target='_blank' rel='nofollow'>Mountain Goat Software Guide to User Stories</a>
- <a href='http://www.romanpichler.com/blog/10-tips-writing-good-user-stories/' target='_blank' rel='nofollow'>Roman Pichler Guide to User Stories</a>
- <a href='https://blog.easyagile.com/how-to-write-good-user-stories-in-agile-software-development-d4b25356b604' target='_blank' rel='nofollow'>How to Write Good User Stories in Agile Software Development</a>
- <a href='https://www.coursera.org/lecture/uva-darden-getting-started-agile/coaching-for-better-user-stories-EV2FE' target='_blank' rel='nofollow'>Coursera course for better User Stories</a>
