---
title: Behavioral Patterns
---

## Behavioral patterns

Behavioral patterns are design patterns that identify common communication problems between objects and realize these patterns. In so doing, these patterns increase flexibility in carrying out communication, making the software more reliable and easy to mantain.

Examples of this type of design pattern include:

1. **Chain of responsibility pattern**: Command objects are handled or passed on to other objects by logic-containing processing objects.
2. **Command pattern**: Command objects encapsulate an action and its parameters.
3. **Interpreter pattern**: Implement a specialized computer language to rapidly solve a specific set of problems.
4. **Iterator pattern**: Iterators are used to access the elements of an aggregate object sequentially without exposing its underlying representation.
5. **Mediator pattern**: Provides a unified interface to a set of interfaces in a subsystem.
6. **Memento pattern**: Provides the ability to restore an object to its previous state (rollback).
7. **Null Object pattern**: Designed to act as a default value of an object.
8. **Observer pattern**: a.k.a. **Publish/Subscribe** or **Event Listener**. Objects register to observe an event that may be raised by another object.
9. **Weak reference pattern**: De-couple an observer from an observable event.
10. **Protocol stack**: Communications are handled by multiple layers, which form an encapsulation hierarchy.
11. **Scheduled-task pattern**: A task is scheduled to be performed at a particular interval or clock time (used in real-time computing).
12. **Single-serving visitor pattern**: Optimize the implementation of a visitor that is allocated, used only once, and then deleted.
13. **Specification pattern**: Recombinable business logic in a boolean fashion.
14. **State pattern**: A clean way for an object to partially change its type at runtime.
15. **Strategy pattern**: Algorithms can be selected on the fly.
16. **Template method pattern**: Describes the skeleton of a program.
17. **Visitor pattern**: A way to separate an algorithm from an object.

### Sources
[Behavioral patterns - Wikipedia](https://en.wikipedia.org/wiki/Behavioral_pattern)
