---
title: Creational patterns
---


## Creational patterns

Creational design patterns are design patterns that deal with object creation mechanisms, trying to create objects in a manner suitable to the situation. The basic form of object creation could result in design problems or added complexity to the design. Creational design patterns solve this problem by somehow controlling this object creation.

Creational design patterns are composed of two dominant ideas. One is encapsulating knowledge about which concrete classes the system uses. Another is hiding how instances of these concrete classes are created and combined.

Five well-known design patterns that are parts of creational patterns are:

1. **Abstract factory pattern**, which provides an interface for creating related or dependent objects without specifying the objects' concrete classes.
2. **Builder pattern**, which separates the construction of a complex object from its representation so that the same construction process can create different representations.
3. **Factory method pattern**, which allows a class to defer instantiation to subclasses.
4. **Prototype pattern**, which specifies the kind of object to create using a prototypical instance, and creates new objects by cloning this prototype.
5. **Singleton pattern**, which ensures that a class only has one instance, and provides a global point of access to it.

### Sources 
1. [Gamma, Erich; Helm, Richard; Johnson, Ralph; Vlissides, John (1995). Design Patterns. Massachusetts: Addison-Wesley. p. 81. ISBN 978-0-201-63361-0. Retrieved 2015-05-22.](http://www.pearsoned.co.uk/bookshop/detail.asp?item=171742)
