---
title: Algorithm Design Patterns
---
## Algorithm Design Patterns

In software engineering, a design pattern is a general repeatable solution to a commonly occurring problem in software design. A design pattern isn't a finished design that can be transformed directly into code. It is a description or template for how to solve a problem that can be used in many different situations. 

Design patterns can speed up the development process by providing tested, proven development paradigms.

These patterns are divided into three major categories:

### Creational patterns

These are design patterns that deal with object creation mechanisms, trying to create objects in a manner suitable to the situation. The basic form of object creation could result in design problems or in added complexity to the design. Creational design patterns solve this problem by somehow controlling this object creation.

### Structural patterns 

These are design patterns that ease the design by identifying a simple way to realize relationships between entities.

### Behavioral patterns

These are design patterns that identify common communication patterns between objects and realize these patterns. By doing so, these patterns increase flexibility in carrying out this communication.

#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
- [Design patterns - Wikipedia](https://en.wikipedia.org/wiki/Design_Patterns)
- [Design patterns tutorial](https://dzone.com/refcardz/design-patterns?chapter=1)
- [Head First Design](https://www.oreilly.com/library/view/head-first-design/0596007124/)

