---
title: Structural patterns
---

## Structural patterns

Structural design patterns are design patterns that ease the design by identifying a simple way to realize relationships between entities and are responsible for building simple and efficient class hierarchies between different classes.

Examples of Structural Patterns include:

1. **Adapter pattern**: 'adapts' one interface for a class into one that a client expects.
2. **Adapter pipeline**: Use multiple adapters for debugging purposes.
3. **Retrofit Interface Pattern**: An adapter used as a new interface for multiple classes at the same time.
4. **Aggregate pattern**: a version of the Composite pattern with methods for aggregation of children.
5. **Bridge pattern**: decouple an abstraction from its implementation so that the two can vary independently.
6. **Tombstone**: An intermediate "lookup" object contains the real location of an object.
7. **Composite pattern**: a tree structure of objects where every object has the same interface.
8. **Decorator pattern**: add additional functionality to a class at runtime where subclassing would result in an exponential rise of new classes.
9. **Extensibility pattern**: a.k.a. Framework - hide complex code behind a simple interface.
10. **Facade pattern**: create a simplified interface of an existing interface to ease usage for common tasks.
11. **Flyweight pattern**: a large quantity of objects share a common properties object to save space.
12. **Marker pattern**: an empty interface to associate metadata with a class.
13. **Pipes and filters**: a chain of processes where the output of each process is the input of the next.
14. **Opaque pointer**: a pointer to an undeclared or private type, to hide implementation details.
15. **Proxy pattern**: a class functioning as an interface to another thing.

### Sources
[Structural patterns - Wikipedia](https://en.wikipedia.org/wiki/Structural_pattern)
