---
title: Search Algorithms
---
## Search Algorithms
In computer science, a search algorithm is any algorithm which solves the Search problem, namely, to retrieve information stored within some data structure or calculated in the search space of a problem domain. Examples of such structures include Linked Lists, Array data structures, Search trees and many more. The appropriate search algorithm often depends on the data structure being searched but also on prior knowledge about the data.
<a href='https://en.wikipedia.org/wiki/Search_algorithm' target='_blank' rel='nofollow'>More on Wikipedia</a>.

This kind of algorithm looks at the problem of re-arranging an array of items in ascending order. The two most classical examples of that is the binary search and the merge sort algorithm.

In the following links you can also find more information about:
* [Binary search](https://github.com/freeCodeCamp/freeCodeCamp/tree/master/guide/english/algorithms/search-algorithms/binary-search/index.md)
* [Exponential search](https://github.com/freeCodeCamp/freeCodeCamp/tree/master/guide/english/algorithms/search-algorithms/exponential-search/index.md)
* [Jump search](https://github.com/freeCodeCamp/freeCodeCamp/tree/master/guide/english/algorithms/search-algorithms/jump-search/index.md)
* [Linear search](https://github.com/freeCodeCamp/freeCodeCamp/tree/master/guide/english/algorithms/search-algorithms/linear-search/index.md)
* [Searching-linked-lists-versus-arrays](https://github.com/freeCodeCamp/freeCodeCamp/tree/master/guide/english/algorithms/search-algorithms/searching-linked-lists-versus-arrays/index.md)

#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->

* MIT OCW Introduction to search <a href="https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-01sc-introduction-to-electrical-engineering-and-computer-science-i-spring-2011/unit-4-probability-and-planning/search-algorithms/">search</a> algorithms.
* Princeton University: <a href="https://introcs.cs.princeton.edu/java/42sort/">Sorting and Searching.</a>
* The anatomy of a search engine <a href="http://infolab.stanford.edu/~backrub/google.html">(Google).</a>
