---
title: Cryptocurrency
---
## Cryptocurrency

>Announcing the first release of Bitcoin, a new electronic cash system that uses a peer-to-peer network to prevent double-spending. It’s completely decentralized with no server or central authority.  
>
> – Satoshi Nakamoto, 09 January 2009, announcing Bitcoin on SourceForge.

Cryptocurrency is a subset of digital currency, which acts as a medium of exchange amongst two parties. It is known as crypto-currency because of the utilization of cryptography to strictly assure the security of transactions taking place on the network. There are various cryptocurrencies including Litecoin, Dash, Ethereum, Ripple, and the currently most popular currency - Bitcoin.  A more complete list, with more than 2000, can be found on [CoinMarketCap](https://coinmarketcap.com/).

The original purpose of cryptocurrency was to remove the intervention of an intermediary (middleman) or third-parties in order to make transactions swift and secure, with anonymity maintained for all users operating through their respective systems (called 'nodes') on a network.

There are hundreds to thousands of cryptocurrencies as of 2018 with new ones coming out on a regularly. Most will never take off. This form of peer-to-peer value exchange is in its infancy still; Bitcoin and Cryptocurrencies have yet to become widely used. Venezuela has made history by becoming the first nation to introduce a national cryptocurrency in a time of national emergency with a goal of circumventing US sanctions and access to international financing.

> You can’t stop things like Bitcoin. It will be everywhere and the world will have to readjust. World governments will have to readjust
>
> – John McAfee

Cryptocurrency enables trustless and anonymous transactions since it does not involve any third party - there is no central bank.  Instead, a blockchain keeps a ledger of transactions across a public network of computers. Blockchains are append-only, meaning nobody can change past transactions.

Unlike normal currency, cryptocurrency is infinitely divisible and can be exchanged in tiny fractions. For example, transactions can amount to 0.00007 BTC or even lower.  Currently the smallest amount of bitcoin ever recorded on the block chain is 0.00000001 BTC also called satoshi (in honor of the creator of Bitcoin, Satoshi Nakamoto).

Bitcoin is a deflationary currency as opposed to most Fiat currencies which are affected by inflation over time. There is a max cap on the amount of Bitcoins that can be mined which is 21 million. The circulating supply of Bitcoin has surpassed 17 million. This means that over 80% of the Bitcoins which will be ever be mined, have already been mined.

Upon the completion of mining, it does not necessarily mean the end of data mining as miners can still be incentivized in other methods, namely through transaction fees by other user in order to be included in the ledger.

It will take over 100 years to mine the last bitcoin, ensuring that this cryptocurrency will be a viable option to fiat currency for decades

Every cryptocurrency has three layers:
1. Protocol - The source code that directs the interaction of the network and various clients (aka core)
2. Network - The group of computers that maintain and update the decentralized ledger (aka miners)
3. Application - The software that allows users to make transactions (aka wallet)

Many cryptocurrencies such as Bitcoin can be earned by validating transactions on the network. This process of validation is called "proof of work" and consists of mathematically guessing a random numbers (usually less than a certain determined value or "difficulty") to attempt to match the blockchain's irreversible cryptographic hash function. As more transactions are validated (and rewards for validation are collected) over time, the difficulty of finding the correct hash increases. An increase in the popularity of cryptocurrency mining over the past few years has outpaced the development of the average computational power of a household computer, so in order to mine effectively, one requires a computer (or computers) with especially powerful graphics cards (such as the Nivida GTX 1080) or specialized cryptocurrency mining equipment (such as the Fast-Hash One or CoinTerra TerraMiner IV). It should also be noted that, because of drawbacks of proof-of-work validation (such as energy inefficiency), some cryptocurrencies are exploring alternative algorithms such as "proof of burn".

As with traditional currencies, it is possible to invest in cryptocurrencies. This can be done through centralized exchanges, like Binance, Bittrex, or Coinbase; or decentralized ones like IDEX or EtherDelta. Cryptocurrency trading started to become noticeable around 2013, and the total market capitalization has been on the rise since then, peaking in January of 2018. 

Investment in cryptocurrencies is highly speculative. With much volatility in the market due to the blockchain technologies still being in their infancy and, compounded with a glut of inexperienced investors, the prices of the various currencies often change rapidly.


## Create your own cryptocurrency

### Stages in Building your own Cryptocurrency

Search for a community to publicize your currency:
* At the very start you should always think where to market your currency. Engage with them and learn what they really want to feed on. After a satisfiable round of searching and learning, you can surely move onto coding the coin.

Code your coin to be perpetually un-hackable:
* It is not very difficult to build you coin with some sprinkles of un-hackability with Bitcoin/Ethereum already in place. You can surely use these open source blockchains already in place. The only time that is need will be invested into changes you need to make in these.

Bring in some miners:
* Miners are indispensable for some cryptocurrency but there are some cryptocurrencies like IOTA which doesn’t require any miner as such. You should use some miners for your currency to gain popularity and benefit some people who use their computing resources.

Grow a merchant base:
* Once you get your miners mining for the currency, you should grab hold of some merchants who accept your currency when presente** The trust you build with these people will help you grab a huge set of customers in the long run.

Targeted Marketing:
* Target your customers in local than global reach. Not only it is easier to publicise but also it becomes easier for you to be present in person and gain their confidence.

### Technical Aspects

Technically speaking, you can have variations in new cryptocurrency implementation as of below:

You can fork a popular cryptocurrency like Bitcoin or Litecoin, change some parameters and make your own coin up and running. 

**Pros:**
*	Very customizable as per your requirement
* Easy to list on exchanges
* Mining possible

**Cons:**
*	Technically challenging to implement
*	Will require solid consensus mechanism apart from what already present

You can simply prepare a ERC-20 smart contract in blockchain like Ethereum and let people invest into it using the base currency ETH

**Pros:**
*	Technically very simple to implement
*	Customizable to your requirement
*	Mining not required as base token is ETH and there is already huge list of miners out there.
*	Consensus will be already integrated by Ethereum
*	Implementation will be fast as core blockchain code doesn’t need tweaking

**Cons:**
*	You need to set an exchange value initially between your token and ETH
*	Exchange listing is quite complex

You can also run your blockchain node like in Ethereum which will be pre-funded with a certain number of tokens in the genesis block and miners can do proof of work to get benefitted

**Pros:**
*	No need to deploy any smart contract
*	Can have miner community external of any network

**Cons:**
*	Integrating with public blockchain is difficult
*	Need lot of publicity for random miners to mine
*	Tokens lost in incentivising miners
*	Listing on exchange is very dificult

## Real World Application of Cryptocurrencies

#### Real estate:
Buying a house with your own cryptocurrency is now made possible. The world’s first international real estate agency that accepts cryptocurrency as payment Propy.com. Propy enables you to buy property with the Blockchain technology.
MyCOINrealty.com also makes it possible to advertise homes you can purchase with Bitcoin. A few examples of already made transactions are: A purchase of a spectacular villa in Indonesia worth 1000 BTC in 2014 and 157,000 BTC home in Vegas.

#### Charities:
Corruption keeps a lot of well-wishers from participating. This keeps the money away from people who genuinely need those funds and will continue suffering.
Blockchain and Cryptocurrency can be used to help solve this problem and deter corruption and fund leaks. The World Food Program (WFP) is already using Blockchain to carefully distribute cash assistance to the hungry. 

#### Buying and Selling content:
Artist have to deal through intermediaries to get your work sold. This can be solved by selling your work on websites like Bitpremier.com which provides a market platform for you to sell or buy luxury goods. A great example of a user who benefited from this platform is artist named “Reinier van Schoonderwoerd den Bezemer” a artist based in Amsterdam who sold his piece “Collaboration” at a whopping 10.000 euro

There are many more ways that cryptocurrency is changing aspects of our lives; ranging from economic to social. As crypto gains popularity more and more uses will come into the world of Cryptocurrency. 

## Consensus Protocols:

#### Proof of Work:
In this more well-known protocol, miners compete with each other to solve a math problem first and to be rewarded with a cryptocurrency reward for their work in securing the network. When a math problem is solved, a new block full of transactions gets added onto the blockchain. Bitcoin operates on a proof-of-work algorithm.

#### Proof of Stake:
In proof of stake, the network is secured via network participants staking or wagering their coins. If network participants misbehave, they will lose the coins that they staked. As a reward for properly securing the network, stakers will periodically receive a small amount of coins relative to how many coins they put up for staking. Instead of competing to solve a difficult math problem to validate blocks, block validators under proof of stake are randomly chosen. Proof of stake is typically significantly less energy-intensive than proof of work.


## Permissionless Blockchains
Rather than imposing barriers to entry, permissionless blockchains are public and open for anyone to join. Since such networks can reasonably expect all kind of agents - including malicious actors - the key lies in incentivizing good behavior in a critical majority of the network, such that:
-	The malicious actors cannot take over the network through an escalated attack.
-	The malicious actors cannot collude to undertake an organized majority attack on the network.
-	The payoffs of securing the network are consistently higher than the cost of attacking the network.
-	The cost of attacking the network is prohibitively high.

### Background History on Origins of Cryptocurrency:
[Blockchain Origins Story](https://www.activism.net/cypherpunk/manifesto.html)
Cypherpunks, crypoanarchists, and libertarians paved the way for the right to privacy and deregulating the government's control and diminishing individual citizen's autonomy.

### Different Types of Cryptocurrency
There are many different types of Cryptocurrency, with many new currencies addeded every month. Here are some popular examples:
- [Bitcoin](https://bitcoin.org/en/)
- [Ethereum](https://www.ethereum.org/)
- [XRP](https://ripple.com/xrp/)

### More Information:
- [Cryptocurrency](https://en.wikipedia.org/wiki/Cryptocurrency)    
- [Ultimate Guide to Cryptocurrency](https://blockgeeks.com/guides/what-is-cryptocurrency)
- [Bitcoin](https://en.wikipedia.org/wiki/Bitcoin)
- [National Cryptocurrency](https://minergate.com/blog/countries-with-national-cryptocurrency/)
- [How many Cryptocurrencies are there?](https://www.fool.com/investing/2018/03/16/how-many-cryptocurrencies-are-there.aspx)
