---
title: Features of BlockTech
---
## Features of Blockchain Technology

Blockchain is usually thought of as Bitcoin and cryptocurrency. However, there are many other applications of this technology. We are barely scratching the surface of it. With all the hype around it, it's clear blockchain technology will play an important role in the future of applications and data. But what makes it unique?

In this article, we are going to explore the key characteristic features of blockchain.

#### _* Decentralized System_

> Blockchain is a decentralized dechnology, by design.

When something is controlled by a central authority, where the power to make decisions lies in the hands of the apex of the management, such system is called a centralized system. Banks, for example, are a centralized system, where it's the responsibility of the Governor to make decisions.

On the contrary, when the power is vested in the hands of the people or the users, such system is said to be a decentralized system.
The peer to peer network, Torrent, for example is a decentralised system, where the user has complete control.

![Decentralized Systems](https://raw.githubusercontent.com/Vagisha16/Hw3/master/blockchain_article_pic.jpg)

#### _* Distributed Ledger_

> Blockchains use Distributed Ledger Technology (DLT) to store and access data.

When something is stored on a distributed ledger, multiple copies of it are made across the network at the same time. Unlike traditional databases, distributed ledgers do not have a central database or administration functionality.

![Distributed Ledger](https://qph.fs.quoracdn.net/main-qimg-2e24c4949a63eefa9bbab1773e185cdd)

When applied in a decentralized system like blockchain, each user has a copy of the ledger and participates in the transaction verification. This ensures security. Since the data is distributed, there is no centralized version of the data for the hackers to corrupt. The data and the records are public and easily verifiable. This also eliminates any single point of failure.

#### _* Secure Ecosystem (Cryptographic Hash)_

BlockTech uses the concepts like proof of work and hash encryption to ensure security and immutability. Proof of work involves many people around the world using computational algorithm to try and find the appropriate hash value that satisfies a predefined condition regarding the hash value.

![Hashing](https://raw.githubusercontent.com/Vagisha16/Hw3/master/Hash.png)




![Proof of Work](https://qph.fs.quoracdn.net/main-qimg-098a67b40e4d0f625cf2cbbda2c95df0)

#### _* Mining_

Torrent is a peer-to-peer decentralized network used to share files. Blockchain uses similar technology. What differentiates the two is that, in Torrent, the system relies on the honor code of the users to seed the files. Whereas, in blockchain, the users who are involved in the transaction have economic incentives. These users are called "Miners". The Miners spend their computing resources to solve the cryptographic hashes and ensure immutability and reliability of the transaction. Every successful solution (decryption) ensures some economic benefit - meaning the miner gets currency credited to their wallet.

![Mining](https://raw.githubusercontent.com/Vagisha16/Hw3/master/5f6609014470f4b0122de37eb09dbfc7.jpg)

#### _* Chronological and Time stamped_

Blockchains, ideally, are just very sophisticated linked lists where each block is a repository that stores information pertaining to a transaction and also links to the previous block in the same transaction. These blocks are arranged in an order and are time-stamped during creation to ensure a fair record.

#### _* Consensus Based_

Consensus is an approach to decision making. It is a creative and dynamic way of reaching agreement between all members of a group. A transaction on blockchain can be executed only if all the parties on the network unanimously approve it.

#### _* Proof of Work_

The main feature that allows blockchain to be extremely secure is the use of proof of work. Most cryptocurrency states that the block with the longest chain is the "trusted" chain. The longest chain refers to one with the longest computational work put into it, or the one mined the most. If a malicious user decides to add a transaction in a ledger, it would change the entire block values, meaning the user would have to recompute the entire chain which would be computationally impossible or unincentive.

### Sources

1. [Distributed Ledger](https://searchcio.techtarget.com/definition/distributed-ledger)
2. [What is seeding](http://help.utorrent.com/customer/portal/articles/164656)
3. [Consensus Mechanism](https://www.seedsforchange.org.uk/consensus)
4. [Major Features of Blockchain](https://cryptocurry.com/news/top-4-major-features-blockchain/)
5. [Application and Features of Blockchain](https://arxiv.org/pdf/1806.03693.pdf)
6. [Key Characteristics of the Blockchain](https://www2.deloitte.com/content/dam/Deloitte/in/Documents/industries/in-convergence-blockchain-key-characteristics-noexp.pdf)


### More Resources

1. [Blockchain - Wikipedia](https://en.wikipedia.org/wiki/Blockchain)
2. [What is blockchain technology? - Blockgeeks](https://blockgeeks.com/guides/what-is-blockchain-technology/)
3. [In Blockchain We Trust - MIT Technology Review](https://www.technologyreview.com/s/610781/in-blockchain-we-trust/)
