---
title: Types of Blockchain
---

# Types of Blockchain

<img src="https://upload.wikimedia.org/wikipedia/commons/a/ab/Blockchain_landscape.svg" alt="drawing" width="600"/>

## Main Types of Blockchain
There are a few main types of blockchain that have emerged:
- Private blockchain
- Public blockchain
- Hybrid blockchain
- Consortium/Federated blockchain

These are broad classifications based on the way the tech is used and handled.

### Private Blockchain
Blockchain Technology that is owned by a private party or an organization. It is a decentralized architecture, but some powers to make decisions are vested in the hands of the person in-charge. This architecture is typically more scalable because there is no need for a consensus algorithm for nodes on the network to agree on the state of the blockchain. 

The person in-charge is responsible for giving selective access and permissions such as read and write.

Examples: Bankchain, Hyperledger, Multichain, Ethereum (Private network)

### Public Blockchain
In this architecture, no one is in charge. Anyone and everyone can participate in reading, writing, and auditing the blockchain.

Public Blockchain is open and transparent and therefore it is open for review by anyone willing to do so, at any given time. This architecture requires a consensus algorithm like Proof-of-Work or Proof-of-Stake to make important decisions.

Examples: Bitcoin, Ethereum, Litecoin

### Hybrid Blockchain
A public blockchain which hosts a private network with restricted participation. The private network generates blocks of hashed data stored on the public blockchain, but without sacrificing data privacy. It provides flexible control over what data is kept private and what is shared on the public ledger.

Hybrid blockchain offer the benefits of decentralization and scalability, without requiring consensus from every single node on the network.

Example: XinFin

### Consortium/Federated Blockchain
Consortium/Federated blockchain helps solve the issue of the private blockchain. The issue of sole autonomy by vesting the power in the hands of an individual is handled by putting in-charge more than a single person.

A group of people come together to form a consortium or federation. Which in turn works together for the common good.

Example: [Energy Web Foundation](http://energyweb.org/)

## Hyperledger
There is another category for classification, that is based on the permission granted to the blockchain network. They are classified as:
- Public Permissioned Blockchain
- Private Permissioned Blockchain
- Permissionless Blockchain

[Hyperledger](https://www.hyperledger.org/) is a multi-project open source collaborative effort hosted by The Linux Foundation. It is used to make permissioned blockchain.

## Additional Resources
- [A Beginner's Guide to Blockchain](https://blockgeeks.com/guides/what-is-blockchain-technology/)
- [Different Types of Blockchain](https://coinsutra.com/different-types-blockchains/)
- [Types of Blockchain](https://data-flair.training/blogs/types-of-blockchain/)
