---
title: Font Awesome Icons For Bootstrap
---
## Font Awesome Icons For Bootstrap

Fontawesome Icons provide you with over 675 icons and they come in font format.

#### How To Use:

In the `<head>` of your html include a reference to Font Awesome. 

You can also use Font Awesome's own CDN.
```html
<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.4.1/css/fontawesome.css" integrity="sha384-BzCy2fixOYd0HObpx3GMefNqdbA7Qjcc91RgYeDjrHTIEXqiF00jKvgQG0+zY/7I" crossorigin="anonymous">
```

Additionally, the Font Awesome CDN can supply the brand and regular logos independently.

```html
<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.4.1/css/brands.css" integrity="sha384-Px1uYmw7+bCkOsNAiAV5nxGKJ0Ixn5nChyW8lCK1Li1ic9nbO5pC/iXaq27X5ENt" crossorigin="anonymous">
<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.4.1/css/fontawesome.css" integrity="sha384-BzCy2fixOYd0HObpx3GMefNqdbA7Qjcc91RgYeDjrHTIEXqiF00jKvgQG0+zY/7I" crossorigin="anonymous">
```

Using fontawesome is same as using [Glyphicon](https://www.glyphicons.com/). 
Simply create a `<i>` or `<span>` tag and apply the CSS Prefix `fa` and the icon's name.  A code example has been provided below.

**Code Example:**

`<i class="fa fa-twitter" aria-hidden="true"></i>`

<i class="fa fa-twitter" aria-hidden="true"></i>

`<span class="fa fa-free-code-camp" aria-hidden="true"></span>`

<span class="fa fa-free-code-camp" aria-hidden="true"></span>

Icons inherit the `font-size` of their parent container by default, but sizing can be modified by adding `.fa-*` classes, where `*` is one of `xs, sm, md, lg or [1-5]x`.

#### Font Awesome Icon List:
Complete list of icons provided by Font Awesome is available [here](http://fontawesome.io/cheatsheet/)

`.fa fa-align-left` This is Font Awesome align left icon.

<span class="fa fa-align-left" aria-hidden="true"></span>

`.fa fa-heart` This is Font Awesome heart icon.

<span class="fa fa-heart" aria-hidden="true"></span>

_Note: Do not include the dot in the HTML Class Attribute, referring to the classes with a dot is only used when adjusting the classes in CSS._


#### Font Awesome Free CDN for Version 5

Font Awesome Version 5 extends the free icons to 1480. 

*Use this free CDN for version 5 (currently v5.6.3)*

```html
<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.6.3/css/all.css" integrity="sha384-UHRtZLI+pbxtHCWp1t77Bi1L4ZtiqrqD80Kn4Z8NTSRyMA2Fd33n5dQ8lWUE00s/" crossorigin="anonymous">
```

List of v5 free icons is available [here](https://fontawesome.com/icons?d=gallery&m=free)


#### More Information:
[Font Awesome Cheatsheet](http://fontawesome.io/cheatsheet/)
