---
title: BSD operating system
---
## BSD operating system

![BSD operating system, most notably freeBSD: the power to serve](https://www.freebsd.org/layout/images/logo-red.png)

### Overview

Berkeley Software Distribution (BSD) is a group of related open source Unix-like operating systems (OS) with origins in early versions of Research Unix at Bell Labs.
FreeBSD is the most popular member.

BSD is configured for internet hosting, web hosting, and hosting many servers on one system.
It is the first OS to have added an internet protocol.
BSD OSes have a very strongly enforced time-sharing system, which makes them most useful where resources are shared between processes.
As a comparison, the Linux OS is known to be preferred for single-task processes such as supercomputers and desktops.
Effectively, the BSD multi-tasking forced-interrupt part of timesharing gets in the way of dedicated single processes.

BSD includes a 'Jails' system which is somewhat analogous to Linux Containers -- except with additional security and flexibility in implementation.

### BSD Versions

In contrast to the numerous Linux distributions, there are only four major open source BSDs. Each BSD project maintains its own source tree and its own kernel.

1. FreeBSD
2. NetBSD
3. OpenBSD
4. DragonFlyBSD

### More Information:

[FreeBSD (Wikipedia.org)](https://en.wikipedia.org/wiki/FreeBSD)

[OpenBSD (Wikipedia.org)](https://en.wikipedia.org/wiki/OpenBSD)

[NetBSD (Wikipedia.org)](https://en.wikipedia.org/wiki/NetBSD)

[Comparison of BSD operating systems (Wikipedia.org)](https://en.wikipedia.org/wiki/Comparison_of_BSD_operating_systems)

