---
title: Appendix
---
# C: An Appendix
Because C is such a low-level language, there are a lot of terms that come up that aren't found in a lot of other languages. Here's an appendix to making understanding them easier.

## Compilation
The compilation is the process of taking the human-readable code and turning it into machine-readable code. This process is performed by a compiler.

## Compiler
A compiler is a program that compiles code, meaning it changes it from something human-readable into something machine-readable.

## Debugging/Debugger
Debugging is the process of removing errors ("bugs") from your code. A debugger is a helpful tool that makes that easier.

## GNU+Linux
GNU+Linux is the technically accurate term for what is commonly referred to as "Linux". Linux is a kernel- it's a set of programs that allow software to interact with hardware. When combined with GNU, it becomes an operating system, which allows a person to interact with it.

## GUI
Graphical User Interface. A GUI will allow you to interact with a program by pointing and clicking rather than having to type in commands.

## Header Files
Header files are files containing function declarations that are defined in other source files. These are typically 'included' at the top of a source file.

## Human-readable
The human-readable code is code that can be read by a person- it's not in binary or machine code.

## IDE
Integrated Development Environment. This is mostly an editor but includes tools to check syntax, format code style, compile, and debug a program, which makes writing code easier.

## Libraries
Libraries are useful sets of code that give more functions and features in the language.

## Linker
A piece of Software that combines multiple Object files (usually compiled source code or libraries) into one executable file. Another name for the Linker is a 'Loader'.

## Low-Level language
A low-level programming language contains binary or assembly code which has little or no abstraction from machine level instructions. 

## Machine Code
Machine code is the code that the machine can understand. Remember that computers use numbers, not English, to run.

## Newline
A newline is what gets printed when you hit Enter, and is an example of a whitespace character. You can also add a newline to the output of your program by including '\n' in your print statement.

## Object File
A file that contains Object Code (Machine Code). The file contains output some compilation, meaning it will contain machine code/assembly code.

## Pointer
A pointer is a variable that contains the memory address of another variable. Arrays, Structures and Functions explicitly use pointers which can help produce efficient and easy-to-read code. 

## Source Code
Source code is any collection of code, possibly with comments, written using a human-readable programming language, usually as plain text. The source code is often transformed by an assembler or compiler into binary machine code understood by the computer.

## Whitespace
Whitespace is the characters that you don't see when you type but are there anyway. For example, you can't see spaces, but there is a lot here. Newlines are also whitespace characters, as are tabs.
