---
title: Canvas
---
## HTML5 Canvas

Canvas is a technology introduced in HTML5 which can be accessed by the `<canvas>` tag. It allows graphics to be drawn via JavaScript, and is a powerful tool for interactivity on all modern web browsers. Learn how to draw shapes, manipulate photos, build games, and animate virtually anything following the links below!

## Usage 

```html
<!DOCTYPE html>
<html>
    <body>
      <canvas id="myCanvas" width="200" height="100" style="border:1px solid #000111;"></canvas>
    </body>
</html>
```

1. In the above example, the `"id=myCanvas"` attribute is referred by JavaScript.
2. The `"width"` & `"height"` attributes are necessary to define the size of the canvas.
3. By default, `<canvas>` element has no border & no content. So, to add a border we use the `"style"` attribute.
4. We can have multiple `<canvas>` elements on one HTML page.

#### More Information

- [MDN Canvas API](https://developer.mozilla.org/en-US/docs/Web/API/Canvas_API)
- [HTML Canvas Deep Dive](https://joshondesign.com/p/books/canvasdeepdive/title.html)
