---
title: Ditch Custom CSS for Bootstrap
---
## Ditch Custom CSS for Bootstrap

The challenge has you doing a lot of things, remove CSS styles, elements and add classes in place of old ones.

### Hint

Check if you have completed all of the required tasks for the challenge.

### Solution

Change all the code in your document to:

```html
<link href="http://192.168.109.2/resources/google-fonts/cssFetch.php?family=Lobster" rel="stylesheet" type="text/css">
<style>
  
  h2 {
    font-family: Lobster, Monospace;
  }

  .thick-green-border {
    border-color: green;
    border-width: 10px;
    border-style: solid;
    border-radius: 50%;
  }
</style>

<div class="container-fluid">
  <h2 class="text-primary text-center">CatPhotoApp</h2>

  <a href="#"><img class="img-responsive thick-green-border" src="http://192.168.109.2/resources/imageLibrary/silverTabbyLarge.jpg" alt="A cute silver tabby lounging."></a>

  <img src="http://192.168.109.2/resources/imageLibrary/twoSilverTabbies.jpg" class="img-responsive" alt="Two kittens hanging out.">
  <div class="row">
    <div class="col-xs-4">
      <button class="btn btn-block btn-primary">Like</button>
    </div>
    <div class="col-xs-4">
      <button class="btn btn-block btn-info">Info</button>
    </div>
    <div class="col-xs-4">
      <button class="btn btn-block btn-danger">Delete</button>
    </div>
  </div>
  <p>Things cats love:</p>
  <ul>
    <li>cat nip</li>
    <li>laser pointers</li>
    <li>lasagna</li>
  </ul>
  <p>Top 3 things cats hate:</p>
  <ol>
    <li>flea treatment</li>
    <li>thunder</li>
    <li>other cats</li>
  </ol>
  <form action="/submit-cat-photo">
    <label><input type="radio" name="indoor-outdoor"> Indoor</label>
    <label><input type="radio" name="indoor-outdoor"> Outdoor</label>
    <label><input type="checkbox" name="personality"> Loving</label>
    <label><input type="checkbox" name="personality"> Lazy</label>
    <label><input type="checkbox" name="personality"> Crazy</label>
    <input type="text" placeholder="cat photo URL" required>
    <button type="submit">Submit</button>
  </form>
</div>
```
