---
title: Information Security and Quality Assurance
---
## Information Security and Quality Assurance

FreeCodeCamp's Information Security And Quality Assurance certification covers two distinct fields of development - Information Security and Quality Assurance.

## Information Security

Information security (sometimes referred to as InfoSec) is a discipline which seeks to prevent and mitigate unauthorized access, disclosure, exploitation, and disruption of information. InfoSec principles apply to any kind of stored information, physical or digital.

Three principles make up the core of InfoSec - confidentiality, integrity, and availability. 

- Confidentiality: information is not to be made available or disclosed to unauthorized parties or processes.
- Integrity: data should remain accurate and complete over its entire lifespan - it shouldn't be modified or altered in transmission.
- Availability: information systems should be accessible when needed.

FreeCodeCamp's Information Security component of the curriculum demonstrates the use of the HelmetJS library which promotes security through the use of HTTP headers. It also demonstrates the use of hashing algorithms to help secure data. The Advanced Node and Express Challenges demonstrate use of the Passport library.

## Quality Assurance

Quality assurance seeks to ensure that a complex program remains functioning as expected throughout revisions. Examples of quality assurance processes include setting project requirements, code reviews, and software testing.

Behavior-driven development (BDD) is a software development practice that emerged from test-driven development (TDD). These are methodologies for driving development and ensuring that software is constructed in line with its design requirements.
BDD sets forth clear acceptance criteria to test your software, and makes it easy to create automated tests with libraries such as Chai.

FreeCodeCamp's Quality Assurance component of the curriculum focuses on testing using Chai, an assertion library for node.

### Resources
- [Chai](https://www.chaijs.com/)
- [HelmetJS](https://helmetjs.github.io/)
