---
title: Create a Horizontal Line Using the hr Element
---
## Create a Horizontal Line Using the hr Element

The `hr` tag is one of the simplest HTML elements. It represents a thematic change in content and creates a thin horizontal line across its parent element.

This lesson requires you to use the `hr` tag to separate the title and content of a "card". So how do you create an `hr` element?

```html
<!-- It's this easy. Note that it does not have a closing tag. -->
<hr>
```

Add this tag between the title and content to create the horizontal line in [this lesson](https://learn.freecodecamp.org/responsive-web-design/applied-visual-design/create-a-horizontal-line-using-the-hr-element/) on [freeCodeCamp](https://www.freecodecamp.org/). Here is a screenshot from that lesson showing an `hr` element contained within the "cardText" div.

![Example hr](https://i.imgur.com/RMTqXPw.png)

## Resources:
* [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/hr)
* [W3C](http://w3c.github.io/html-reference/hr.html)
