---
title: Adjust the Margin of an Element
---
## Adjust the Margin of an Element

Adjusting the `Margin` of an `Element` means to increase or decrease the amount of spacing between the Element's borders and surrounding Elements.

  • Margins are adjusted with positive and negative integers by units of pixels(`px`).

  • Margins can be created from all directions (top, bottom, left, right).

This is an example of how it is written:
```css
margin: 20px;
```

You can easily change or adjust the `Margin` of an `Element` by changing the numerical value:

<b>Before</b>:

margin: `20`px;

<b>After</b>:

margin: `50`px;

You can also create a custom `class` with a `margin` that you will use repetitively. 

```css
  .style-margin {
    margin: 20px;
  }
```

```html
<h2 class="style-margin">Example</h2>
```
