---
title: Add Placeholder Text to a Text Field
---
## Add Placeholder Text to a Text Field

`placeholder` is an attribute, not a tag. It can be used together with the attribute `text` of the `input` tag to create a text to visualize when the input box is empty. 

```HTML
 <input type=text placeholder="This is a placeholder text">
```

If you're stuck check for these issues:
 - you should add the `placeholder` attribute to the `input` tag already present in the code without removing anything; if by accident you removed or modified something remember that you can restart with a clean code by clicking `reset all code` button
 - the syntax is the same of every attribute: `<tag attributeName="attributeValue" >` and the value to insert is indicated by the challenge's instructions (check for typos).

Good luck!
