---
title: Create a Text Field
---
## Create a Text Field

`input` could be classified as a generic tag: indeed it is characterized by its attribute `type`, which can assume a range of different values and based on that value then `input` will be rendered as a different object.

A few example of different `type` values:

type value | code 
--|--
text | `<input type="text" />` 
checkbox | `<input type="checkbox" />` 
radio | `<input type="radio" />` 
button | `<input type="button" />` 
...

The challenge want you to lay down a `input` tag with type set to `text` without modify the existing code; if something went wrong double check tag errors ( since `input` is self-closing you just need one tag, not a pair open-close ).
If you modified or deleted some parts of the provided code you can restart using the `reset all code` button.

Good luck!
