---
title: Amazon Web Services
---
## Amazon Web Services

Amazon Web Services, or AWS for short, is a subsidiary of Amazon.com that provides on-demand cloud computing platforms to individuals, companies and governments on a
paid subscription basis with a free-tier option available for 12 months. AWS, along with Microsoft's Azure and Google's Cloud Platform, are considered the three major
public cloud vendors.

The technology allows subscribers to have at their disposal a full-fledged virtual cluster of computers, available all the time, through the internet. AWS's version of
virtual computers have most of the attributes of a real computer including hardware (CPU(s) & GPU(s) for processing, local/RAM memory, hard-disk/SSD storage); a choice
of operating systems; networking; and pre-loaded application software such as web servers, databases, CRM, etc. Each AWS system also virtualizes its console I/O (keyboard,
display, and mouse), allowing AWS subscribers to connect to their AWS system from anywhere in the world using a modern browser. The browser acts as a window into the
virtual computer, letting subscribers log-in, configure and use their virtual systems just as they would a real physical computer.

Subscribers can choose to deploy their AWS systems to provide internet-based services for their own and their customers' benefit.  Since individuals or organizations
using AWS do not physically own the AWS infrastructure, they do not have to deal with some of the maintenance tasks associated with owning a physical datacenter such as
operating networking equipment.

AWS in particular has also been expanding on their cloud offerings. They are providing innovative services such as AWS Lambda, in which users only need to focus on
writing code and not on the servers that will be running their code (giving rise to the new *serverless* movement). As a result of these benefits, cloud computing
platforms such as AWS have been popular among startups who might initially have less capital to invest into their Information Technology or IT. Instead, they can focus
on building great products for their users and growing their business over time with AWS’s on demand model.

Popular AWS services include:
* Virtual Machines via the EC2 (Elastic Compute Cloud) platform
* Databases including both SQL and NoSQL
* S3 (Simple Storage Service)
* SQS (Simple Queue Service)
* Games development via the Amazon Lumberyard game development engine and subsequent hosting platform
* DynamoDB (Amazon Dynamo Data Base)
* CloudWatch (Metrics and Alarms)
* CodeDeploy (Deployments)  
* Lambda (Serverless)
* Application Monitoring tools
* Mobile development tools and platforms
* Amazon Alexa development area
* Simple Notification Service (SNS)
* CloudFormation (Infrastructure as Code)

#### AWS Certifications 

AWS offers many different certifications for its practitioners. AWS offers a prerequisite AWS Cloud Practitioner Essentials certification relevant to anyone no matter their role. There are different tiers to AWS certs as well as role-based certifications. 

The roles are:
* Any role:
   * [Foundational: AWS Certified Cloud Practitioner](https://aws.amazon.com/certification/certified-cloud-practitioner/)
* Architect:
   * [Foundational: AWS Certified Cloud Practitioner (optional)](https://aws.amazon.com/certification/certified-cloud-practitioner/)
   * [Associate: AWS Certified Solutions Architect - Associate](https://aws.amazon.com/certification/certified-solutions-architect-associate/)
   * [Professional: AWS Certified Solutions Architect - Professional](https://aws.amazon.com/certification/certified-solutions-architect-professional/)
* Developer:
   * [Foundational: AWS Certified Cloud Practitioner (optional)](https://aws.amazon.com/certification/certified-cloud-practitioner/)
   * [Associate: AWS Certified Developer - Associate](https://aws.amazon.com/certification/certified-developer-associate/)
   * [Professional: AWS Certified DevOps Engineer - Professional](https://aws.amazon.com/certification/certified-devops-engineer-professional/)
* Operational:
   * [Foundational: AWS Certified Cloud Practitioner (optional)](https://aws.amazon.com/certification/certified-cloud-practitioner/)
   * [Associate: AWS Certified SysOps Administrator - Associate](https://aws.amazon.com/certification/certified-sysops-admin-associate/)
   * [Professional: AWS Certified DevOps Engineer - Professional](https://aws.amazon.com/certification/certified-devops-engineer-professional/)
* Specialty (unrelated to eachother):
   * [AWS Certified Big Data - Specialty](https://aws.amazon.com/certification/certified-big-data-specialty)
   * [AWS Certified Advanced Networking - Specialty](https://aws.amazon.com/certification/certified-advanced-networking-specialty)
   * [AWS Certified Security - Specialty](https://aws.amazon.com/certification/certified-security-specialty/)

#### More Information:
* [AWS](https://aws.amazon.com/)
* [Certifications](https://aws.amazon.com/certification/)
* [Certification Preparation](https://aws.amazon.com/certification/certification-prep/)
* [Wikipedia](https://en.wikipedia.org/wiki/Amazon_Web_Services)
* [Pricing](https://aws.amazon.com/pricing/?nc2=h_ql_pr)
* [Simple Monthly Cost Calculator](http://calculator.s3.amazonaws.com/index.html)
* [TCO Calculator](https://aws.amazon.com/tco-calculator/)
